/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.ndailyrewards.utils;

import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bxteam.ndailyrewards.utils.HeadUtil;
import org.bxteam.ndailyrewards.utils.TextUtils;

public class ItemBuilder {
    private final ItemStack itemStack;
    private final ItemMeta meta;
    private static final Pattern customModelPattern = Pattern.compile("CustomModel\\[(\\w+):(\\d+)]\\{(\\d+)}");
    private static final Pattern customSkullPattern = Pattern.compile("CustomSkull\\[(\\w+):(\\d+)]\\{(UUID|URL|BASE64):(\\S+)}");
    private static final Pattern defaultPattern = Pattern.compile("(\\w+):(\\d+)");

    public ItemBuilder(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.meta = itemStack.getItemMeta();
    }

    public static ItemStack parseItemStack(String input) {
        Matcher customModelMatcher = customModelPattern.matcher(input);
        Matcher customSkullMatcher = customSkullPattern.matcher(input);
        Matcher defaultMatcher = defaultPattern.matcher(input);
        if (customModelMatcher.matches()) {
            Material material = Material.valueOf((String)customModelMatcher.group(1).toUpperCase());
            int quantity = Integer.parseInt(customModelMatcher.group(2));
            int customModelData = Integer.parseInt(customModelMatcher.group(3));
            return new ItemBuilder(new ItemStack(material, quantity)).setCustomModelData(customModelData).build();
        }
        if (customSkullMatcher.matches()) {
            Material material = Material.valueOf((String)customSkullMatcher.group(1).toUpperCase());
            int quantity = Integer.parseInt(customSkullMatcher.group(2));
            String type = customSkullMatcher.group(3);
            String value = customSkullMatcher.group(4);
            ItemStack skullItem = new ItemStack(material, quantity);
            if (material == Material.PLAYER_HEAD) {
                skullItem = switch (type) {
                    case "UUID" -> HeadUtil.itemFromUuid(UUID.fromString(value));
                    case "URL" -> HeadUtil.itemFromUrl(value);
                    case "BASE64" -> HeadUtil.itemFromBase64(value);
                    default -> skullItem;
                };
                skullItem.setAmount(quantity);
            }
            return skullItem;
        }
        if (defaultMatcher.matches()) {
            Material material = Material.valueOf((String)defaultMatcher.group(1).toUpperCase());
            int quantity = Integer.parseInt(defaultMatcher.group(2));
            return new ItemStack(material, quantity);
        }
        throw new IllegalArgumentException("Invalid item string: " + input);
    }

    public ItemBuilder setName(String name) {
        this.meta.setDisplayName(TextUtils.applyColor(name));
        return this;
    }

    public ItemBuilder setLore(List<String> lore) {
        List coloredLore = lore.stream().map(TextUtils::applyColor).collect(Collectors.toList());
        this.meta.setLore(coloredLore);
        return this;
    }

    public ItemBuilder setCustomModelData(int customModelData) {
        this.meta.setCustomModelData(Integer.valueOf(customModelData));
        return this;
    }

    public ItemStack build() {
        this.itemStack.setItemMeta(this.meta);
        return this.itemStack;
    }

    public Material getType() {
        return this.itemStack.getType();
    }
}

