/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.ndailyrewards.utils;

import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Base64;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Skull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public final class HeadUtil {
    public static ItemStack createSkull() {
        return new ItemStack(Material.PLAYER_HEAD);
    }

    @Deprecated
    public static ItemStack itemFromName(String name) {
        return HeadUtil.itemWithName(HeadUtil.createSkull(), name);
    }

    public static ItemStack itemFromUuid(UUID id) {
        return HeadUtil.itemWithUuid(HeadUtil.createSkull(), id);
    }

    public static ItemStack itemFromUrl(String url) {
        return HeadUtil.itemWithUrl(HeadUtil.createSkull(), url);
    }

    public static ItemStack itemFromBase64(String base64) {
        return HeadUtil.itemWithBase64(HeadUtil.createSkull(), base64);
    }

    @Deprecated
    public static ItemStack itemWithName(ItemStack item, String name) {
        HeadUtil.notNull(item, "item");
        HeadUtil.notNull(name, "name");
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        meta.setOwningPlayer(Bukkit.getOfflinePlayer((String)name));
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    public static ItemStack itemWithUuid(ItemStack item, UUID id) {
        HeadUtil.notNull(item, "item");
        HeadUtil.notNull(id, "id");
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        meta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)id));
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    public static ItemStack itemWithUrl(ItemStack item, String url) {
        HeadUtil.notNull(item, "item");
        HeadUtil.notNull(url, "url");
        return HeadUtil.itemWithBase64(item, HeadUtil.urlToBase64(url));
    }

    public static ItemStack itemWithBase64(ItemStack item, String base64) {
        HeadUtil.notNull(item, "item");
        HeadUtil.notNull(base64, "base64");
        ItemMeta itemMeta = item.getItemMeta();
        if (!(itemMeta instanceof SkullMeta)) {
            return null;
        }
        SkullMeta meta = (SkullMeta)itemMeta;
        HeadUtil.mutateItemMeta(meta, base64);
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    @Deprecated
    public static void blockWithName(Block block, String name) {
        HeadUtil.notNull(block, "block");
        HeadUtil.notNull(name, "name");
        Skull state = (Skull)block.getState();
        state.setOwningPlayer(Bukkit.getOfflinePlayer((String)name));
        state.update(false, false);
    }

    public static void blockWithUuid(Block block, UUID id) {
        HeadUtil.notNull(block, "block");
        HeadUtil.notNull(id, "id");
        HeadUtil.setToSkull(block);
        Skull state = (Skull)block.getState();
        state.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)id));
        state.update(false, false);
    }

    public static void blockWithUrl(Block block, String url) {
        HeadUtil.notNull(block, "block");
        HeadUtil.notNull(url, "url");
        HeadUtil.blockWithBase64(block, HeadUtil.urlToBase64(url));
    }

    public static void blockWithBase64(Block block, String base64) {
        HeadUtil.notNull(block, "block");
        HeadUtil.notNull(base64, "base64");
        HeadUtil.setToSkull(block);
        Skull state = (Skull)block.getState();
        HeadUtil.mutateBlockState(state, base64);
        state.update(false, false);
    }

    private static void setToSkull(Block block) {
        block.setType(Material.PLAYER_HEAD, false);
    }

    private static void notNull(Object o, String name) {
        if (o == null) {
            throw new NullPointerException(name + " should not be null!");
        }
    }

    private static String urlToBase64(String url) {
        URI actualUrl;
        try {
            actualUrl = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        String toEncode = "{\"textures\":{\"SKIN\":{\"url\":\"" + String.valueOf(actualUrl) + "\"}}}";
        return Base64.getEncoder().encodeToString(toEncode.getBytes());
    }

    private static PlayerProfile makeProfile(String b64) {
        UUID id = new UUID(b64.substring(b64.length() - 20).hashCode(), b64.substring(b64.length() - 10).hashCode());
        PlayerProfile profile = Bukkit.createProfile((UUID)id, (String)"Player");
        profile.setProperty(new ProfileProperty("textures", b64));
        return profile;
    }

    private static void mutateBlockState(Skull block, String b64) {
        block.setPlayerProfile(HeadUtil.makeProfile(b64));
    }

    private static void mutateItemMeta(SkullMeta meta, String b64) {
        meta.setPlayerProfile(HeadUtil.makeProfile(b64));
    }

    @Generated
    private HeadUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

