/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.ndailyrewards.manager.reward;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bxteam.commons.logger.ExtendedLogger;
import org.bxteam.ndailyrewards.manager.reward.ActionType;
import org.bxteam.ndailyrewards.manager.reward.Reward;
import org.bxteam.ndailyrewards.utils.TextUtils;

public class ActionsExecutor {
    private final ExtendedLogger logger;
    private final Player player;
    private final Reward reward;
    private final String[] titleText = new String[]{"", ""};
    private final Random random = new Random();

    @Inject
    public ActionsExecutor(ExtendedLogger logger, @Assisted Player player, @Assisted Reward reward) {
        this.logger = logger;
        this.player = player;
        this.reward = reward;
    }

    public void execute() {
        this.reward.actions().forEach(action -> {
            ActionType actionType = ActionType.fromAction(action);
            if (actionType == null) {
                return;
            }
            String command = StringUtils.replace((String)action, (String)actionType.getPrefix(), (String)"").trim();
            String placeholders = TextUtils.applyPlaceholders(this.player, command);
            String coloredLine = TextUtils.applyColor(placeholders);
            try {
                switch (actionType) {
                    case CONSOLE: {
                        String consoleCommand = StringUtils.replace((String)coloredLine, (String)"<player>", (String)this.player.getName());
                        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)consoleCommand);
                        break;
                    }
                    case PLAYER: {
                        this.player.performCommand(coloredLine);
                        break;
                    }
                    case MESSAGE: {
                        this.player.sendMessage(coloredLine);
                        break;
                    }
                    case ACTIONBAR: {
                        this.player.sendActionBar(coloredLine);
                        break;
                    }
                    case SOUND: {
                        String[] parts = coloredLine.split(":");
                        if (parts.length != 3) break;
                        try {
                            Sound sound = Sound.valueOf((String)parts[0]);
                            float volume = Float.parseFloat(parts[1]);
                            float pitch = Float.parseFloat(parts[2]);
                            this.player.playSound(this.player.getLocation(), sound, volume, pitch);
                        }
                        catch (IllegalArgumentException e) {
                            this.logger.warn("Invalid sound action: " + action);
                        }
                        break;
                    }
                    case TITLE: {
                        this.titleText[0] = coloredLine;
                        break;
                    }
                    case SUBTITLE: {
                        this.titleText[1] = coloredLine;
                        break;
                    }
                    case PERMISSION: {
                        String[] permParts = coloredLine.split(" ", 2);
                        if (permParts.length != 2) break;
                        String permission = permParts[0].replace("{", "").replace("}", "");
                        if (this.player.hasPermission(permission)) {
                            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)permParts[1].replace("<player>", this.player.getName()));
                        }
                        break;
                    }
                    case LUCK: {
                        if (!coloredLine.startsWith("{") || !coloredLine.contains("}")) break;
                        int endIndex = coloredLine.indexOf("}");
                        String chanceString = coloredLine.substring(1, endIndex);
                        try {
                            int chance = Integer.parseInt(chanceString);
                            String luckCommand = coloredLine.substring(endIndex + 1).trim();
                            if (this.random.nextInt(100) < chance) {
                                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)luckCommand.replace("<player>", this.player.getName()));
                            }
                        }
                        catch (NumberFormatException e) {
                            this.logger.warn("Invalid luck action: " + action);
                        }
                        break;
                    }
                    case CLOSE: {
                        this.player.closeInventory();
                    }
                }
            }
            catch (Exception e) {
                this.logger.error("Error executing action: " + e.getMessage());
            }
        });
        if (!this.titleText[0].isEmpty() || !this.titleText[1].isEmpty()) {
            this.player.sendTitle(this.titleText[0], this.titleText[1], 10, 70, 20);
        }
    }

    public static interface Factory {
        public ActionsExecutor create(Player var1, Reward var2);
    }
}

