/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.ndailyrewards.manager.menu;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bxteam.commons.scheduler.Scheduler;
import org.bxteam.commons.scheduler.Task;
import org.bxteam.ndailyrewards.configuration.Language;
import org.bxteam.ndailyrewards.manager.reward.PlayerRewardData;
import org.bxteam.ndailyrewards.manager.reward.RewardManager;
import org.bxteam.ndailyrewards.utils.ItemBuilder;
import org.bxteam.ndailyrewards.utils.TextUtils;
import org.jetbrains.annotations.NotNull;

@Singleton
public class MenuManager {
    private final Plugin plugin;
    private final RewardManager rewardManager;
    private final Scheduler scheduler;
    private final InventoryHolder MAIN_MENU_HOLDER = new MainMenuHolder();
    private ItemStack cachedFillerItem;
    private final Map<Integer, DayItems> dayItemsCache = new HashMap<Integer, DayItems>();
    private final List<CustomItemConfig> cachedCustomItems = new ArrayList<CustomItemConfig>();
    private final Map<Integer, Integer> slotToDayMap = new HashMap<Integer, Integer>();
    private final Set<Player> openMenuPlayers = ConcurrentHashMap.newKeySet();
    private Task updateTask;

    @Inject
    public MenuManager(Plugin plugin, RewardManager rewardManager, Scheduler scheduler) {
        this.plugin = plugin;
        this.rewardManager = rewardManager;
        this.scheduler = scheduler;
        this.initializeCaches();
        this.startGlobalUpdateTask();
    }

    private void initializeCaches() {
        ConfigurationSection daysSection;
        ConfigurationSection customSection;
        FileConfiguration config = this.plugin.getConfig();
        if (config.getBoolean("gui.reward.display.filler.enable") && this.cachedFillerItem == null) {
            this.cachedFillerItem = this.loadFillItem();
        }
        if ((customSection = config.getConfigurationSection("gui.reward.custom")) != null && this.cachedCustomItems.isEmpty()) {
            for (String customKey : customSection.getKeys(false)) {
                String materialStr = customSection.getString(customKey + ".material");
                String name = customSection.getString(customKey + ".name");
                List lore = customSection.getStringList(customKey + ".lore");
                int position = customSection.getInt(customKey + ".position");
                ItemStack customItem = new ItemBuilder(ItemBuilder.parseItemStack(materialStr)).setName(name).setLore(lore).build();
                this.cachedCustomItems.add(new CustomItemConfig(position, customItem));
            }
        }
        if ((daysSection = config.getConfigurationSection("rewards.days")) != null && this.dayItemsCache.isEmpty()) {
            for (String dayKey : daysSection.getKeys(false)) {
                int day = Integer.parseInt(dayKey);
                ConfigurationSection daySection = daysSection.getConfigurationSection(dayKey);
                if (daySection == null) continue;
                DayItems dayItems = this.preCacheDayItems(day, daySection);
                this.dayItemsCache.put(day, dayItems);
                this.slotToDayMap.put(dayItems.position, day);
            }
        }
    }

    private void startGlobalUpdateTask() {
        this.updateTask = this.scheduler.runTaskTimer(() -> {
            long currentTime = System.currentTimeMillis() / 1000L;
            for (Player player : this.openMenuPlayers) {
                this.updatePlayerInventory(player, currentTime);
            }
        }, 20L, 20L);
    }

    public void openRewardsMenu(Player player) {
        FileConfiguration config = this.plugin.getConfig();
        ((CompletableFuture)this.rewardManager.checkResetForPlayerAsync(player.getUniqueId()).thenCompose(wasReset -> {
            if (wasReset.booleanValue()) {
                this.scheduler.runTask(() -> player.sendMessage(Language.PREFIX.asColoredString() + Language.CLAIM_REWARD_RESET.asColoredString()));
            }
            return this.rewardManager.getPlayerRewardDataAsync(player.getUniqueId());
        })).thenAccept(arg_0 -> this.lambda$openRewardsMenu$4((ConfigurationSection)config, player, arg_0));
    }

    private void populateDayItems(Inventory inventory, PlayerRewardData playerRewardData, long currentTime) {
        int currentDay = playerRewardData.currentDay();
        long nextTime = playerRewardData.next();
        for (DayItems cached : this.dayItemsCache.values()) {
            ItemStack toSet = currentDay >= cached.day ? cached.claimed : (currentDay + 1 == cached.day && currentTime >= nextTime ? cached.available : (currentDay + 1 == cached.day && currentTime < nextTime ? this.updateNextItemTime(cached.nextTemplate, nextTime - currentTime) : cached.unavailable));
            inventory.setItem(cached.position, toSet);
        }
    }

    private void updatePlayerInventory(Player player, long currentTime) {
        if (!player.isOnline()) {
            this.openMenuPlayers.remove(player);
            return;
        }
        Inventory inventory = player.getOpenInventory().getTopInventory();
        if (!(inventory.getHolder() instanceof MainMenuHolder)) {
            this.openMenuPlayers.remove(player);
            return;
        }
        this.rewardManager.getPlayerRewardDataAsync(player.getUniqueId()).thenAccept(playerRewardData -> {
            if (playerRewardData != null) {
                this.scheduler.runTask(() -> this.populateDayItems(inventory, (PlayerRewardData)playerRewardData, currentTime));
            }
        });
    }

    private ItemStack loadFillItem() {
        String material = this.plugin.getConfig().getString("gui.reward.display.filler.material");
        String name = this.plugin.getConfig().getString("gui.reward.display.filler.name");
        List lore = this.plugin.getConfig().getStringList("gui.reward.display.filler.lore");
        return new ItemBuilder(ItemBuilder.parseItemStack(Objects.requireNonNull(material))).setName(name).setLore(lore).build();
    }

    private DayItems preCacheDayItems(int day, ConfigurationSection daySection) {
        int position = daySection.getInt("position");
        List<String> rewardLore = daySection.getStringList("lore").stream().map(TextUtils::applyColor).collect(Collectors.toList());
        ItemStack claimed = this.createStaticItem("claimed", day, rewardLore);
        ItemStack available = this.createStaticItem("available", day, rewardLore);
        ItemStack unavailable = this.createStaticItem("unavailable", day, rewardLore);
        ItemStack nextTemplate = this.createNextTemplate(day, rewardLore);
        return new DayItems(day, position, claimed, available, unavailable, nextTemplate);
    }

    private ItemStack createStaticItem(String type, int day, List<String> rewardLore) {
        String material = this.plugin.getConfig().getString("gui.reward.display." + type + ".material");
        String name = Objects.requireNonNull(this.plugin.getConfig().getString("gui.reward.display." + type + ".name")).replace("<dayNum>", String.valueOf(day));
        List<String> loreFormatted = this.plugin.getConfig().getStringList("gui.reward.display." + type + ".lore").stream().map(s -> s.replace("<reward-lore>", String.join((CharSequence)"\n", rewardLore))).flatMap(s -> Arrays.stream(s.split("\n"))).map(TextUtils::applyColor).collect(Collectors.toList());
        return new ItemBuilder(ItemBuilder.parseItemStack(Objects.requireNonNull(material))).setName(name).setLore(loreFormatted).build();
    }

    private ItemStack createNextTemplate(int day, List<String> rewardLore) {
        String material = this.plugin.getConfig().getString("gui.reward.display.next.material");
        String name = Objects.requireNonNull(this.plugin.getConfig().getString("gui.reward.display.next.name")).replace("<dayNum>", String.valueOf(day));
        List<String> loreTemplate = this.plugin.getConfig().getStringList("gui.reward.display.next.lore").stream().map(s -> s.replace("<reward-lore>", String.join((CharSequence)"\n", rewardLore))).flatMap(s -> Arrays.stream(s.split("\n"))).map(TextUtils::applyColor).collect(Collectors.toList());
        return new ItemBuilder(ItemBuilder.parseItemStack(Objects.requireNonNull(material))).setName(name).setLore(loreTemplate).build();
    }

    private ItemStack updateNextItemTime(ItemStack template, long timeLeft) {
        ItemStack copy = template.clone();
        ItemMeta meta = copy.getItemMeta();
        if (meta == null) {
            return copy;
        }
        List lore = meta.getLore();
        if (lore == null) {
            return copy;
        }
        String formattedTime = this.formatTime(timeLeft);
        ArrayList<String> newLore = new ArrayList<String>(lore.size());
        for (String line : lore) {
            newLore.add(line.replace("<time-left>", formattedTime));
        }
        meta.setLore(newLore);
        copy.setItemMeta(meta);
        return copy;
    }

    private String formatTime(long seconds) {
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        long secs = seconds % 60L;
        return String.format("%02d:%02d:%02d", hours, minutes, secs);
    }

    public void shutdown() {
        if (this.updateTask != null && !this.updateTask.isCancelled()) {
            this.updateTask.cancel();
        }
        this.openMenuPlayers.clear();
        this.dayItemsCache.clear();
        this.cachedCustomItems.clear();
        this.slotToDayMap.clear();
        this.cachedFillerItem = null;
    }

    public void refreshPlayerInventory(Player player) {
        if (!player.isOnline()) {
            this.openMenuPlayers.remove(player);
            return;
        }
        Inventory inventory = player.getOpenInventory().getTopInventory();
        if (!(inventory.getHolder() instanceof MainMenuHolder)) {
            this.openMenuPlayers.remove(player);
            return;
        }
        this.rewardManager.getPlayerRewardDataAsync(player.getUniqueId()).thenAccept(playerRewardData -> {
            if (playerRewardData != null) {
                this.scheduler.runTask(() -> {
                    long currentTime = System.currentTimeMillis() / 1000L;
                    this.populateDayItems(inventory, (PlayerRewardData)playerRewardData, currentTime);
                });
            }
        });
    }

    private /* synthetic */ void lambda$openRewardsMenu$4(ConfigurationSection config, Player player, PlayerRewardData playerRewardData) {
        int size = config.getInt("gui.reward.size");
        String title = TextUtils.applyColor(config.getString("gui.reward.title"));
        boolean useFiller = config.getBoolean("gui.reward.display.filler.enable");
        this.scheduler.runTask(() -> {
            Inventory inventory = Bukkit.createInventory((InventoryHolder)this.MAIN_MENU_HOLDER, (int)size, (String)title);
            if (useFiller && this.cachedFillerItem != null) {
                for (int i = 0; i < size; ++i) {
                    inventory.setItem(i, this.cachedFillerItem);
                }
            }
            for (CustomItemConfig cic : this.cachedCustomItems) {
                inventory.setItem(cic.position, cic.itemStack);
            }
            ConfigurationSection daysSection = config.getConfigurationSection("rewards.days");
            if (daysSection != null && playerRewardData != null) {
                this.populateDayItems(inventory, playerRewardData, System.currentTimeMillis() / 1000L);
                this.openMenuPlayers.add(player);
            }
            player.openInventory(inventory);
        });
    }

    public static class MainMenuHolder
    implements InventoryHolder {
        @NotNull
        public Inventory getInventory() {
            return Bukkit.createInventory((InventoryHolder)this, (int)0, (String)"");
        }
    }

    private record CustomItemConfig(int position, ItemStack itemStack) {
    }

    private record DayItems(int day, int position, ItemStack claimed, ItemStack available, ItemStack unavailable, ItemStack nextTemplate) {
    }
}

