/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.ndailyrewards.manager;

import com.google.inject.Injector;
import com.google.inject.Singleton;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.java.JavaPlugin;
import org.bxteam.ndailyrewards.NDailyRewards;
import org.bxteam.ndailyrewards.command.ClaimCommand;
import org.bxteam.ndailyrewards.command.HelpCommand;
import org.bxteam.ndailyrewards.command.MainCommand;
import org.bxteam.ndailyrewards.command.ReloadCommand;
import org.bxteam.ndailyrewards.command.SetDayCommand;
import org.bxteam.ndailyrewards.command.VersionCommand;
import org.bxteam.ndailyrewards.command.lamp.LampExceptionHandler;
import revxrsal.commands.Lamp;
import revxrsal.commands.bukkit.BukkitLamp;
import revxrsal.commands.bukkit.actor.BukkitCommandActor;
import revxrsal.commands.exception.CommandExceptionHandler;

@Singleton
public class CommandManager {
    private final Injector injector;
    private final Lamp<BukkitCommandActor> lamp;

    public CommandManager(NDailyRewards plugin, Injector injector) {
        this.injector = injector;
        this.lamp = BukkitLamp.builder((JavaPlugin)plugin).exceptionHandler((CommandExceptionHandler)new LampExceptionHandler()).suggestionProviders(providers -> providers.addProvider(Integer.class, context -> {
            ConfigurationSection rewards = plugin.getConfig().getConfigurationSection("rewards.days");
            if (rewards == null) {
                return List.of();
            }
            return rewards.getKeys(false).stream().map(Integer::parseInt).map(String::valueOf).toList();
        })).build();
    }

    public void registerCommands() {
        this.lamp.register(new Object[]{this.injector.getInstance(ClaimCommand.class), this.injector.getInstance(HelpCommand.class), this.injector.getInstance(MainCommand.class), this.injector.getInstance(ReloadCommand.class), this.injector.getInstance(SetDayCommand.class), this.injector.getInstance(VersionCommand.class)});
    }

    public void unregisterCommands() {
        if (this.lamp != null) {
            this.lamp.unregisterAllCommands();
        }
    }
}

