/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.ndailyrewards.integration.placeholderapi;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import lombok.Generated;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bxteam.ndailyrewards.integration.Integration;
import org.bxteam.ndailyrewards.manager.reward.PlayerRewardData;
import org.bxteam.ndailyrewards.manager.reward.RewardManager;
import org.jetbrains.annotations.NotNull;

@Singleton
public class PlaceholderAPIIntegration
extends PlaceholderExpansion
implements Integration {
    private final RewardManager rewardManager;
    private final PluginDescriptionFile pluginDescription;

    @Override
    public void enable() {
        this.register();
    }

    @NotNull
    public String getIdentifier() {
        return "dailyrewards";
    }

    @NotNull
    public String getAuthor() {
        return String.join((CharSequence)", ", this.pluginDescription.getAuthors());
    }

    @NotNull
    public String getVersion() {
        return this.pluginDescription.getVersion();
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }

    public String onRequest(OfflinePlayer player, @NotNull String params) {
        if (params.equalsIgnoreCase("reward_day")) {
            PlayerRewardData playerRewardData = this.rewardManager.getPlayerRewardData(player.getUniqueId());
            return String.valueOf(playerRewardData.currentDay() + 1);
        }
        if (params.equalsIgnoreCase("remaining_time")) {
            PlayerRewardData playerRewardData = this.rewardManager.getPlayerRewardData(player.getUniqueId());
            long timeLeft = playerRewardData.next() - System.currentTimeMillis() / 1000L;
            if (timeLeft < 0L) {
                return "00:00:00";
            }
            return this.formatTime(timeLeft);
        }
        return null;
    }

    private String formatTime(long seconds) {
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        long secs = seconds % 60L;
        return String.format("%02d:%02d:%02d", hours, minutes, secs);
    }

    @Inject
    @Generated
    public PlaceholderAPIIntegration(RewardManager rewardManager, PluginDescriptionFile pluginDescription) {
        this.rewardManager = rewardManager;
        this.pluginDescription = pluginDescription;
    }
}

