/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.ndailyrewards.integration;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import lombok.Generated;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bxteam.commons.logger.ExtendedLogger;
import org.bxteam.ndailyrewards.integration.Integration;
import org.bxteam.ndailyrewards.integration.placeholderapi.PlaceholderAPIIntegration;
import org.bxteam.ndailyrewards.manager.reward.RewardManager;

@Singleton
public class IntegrationRegistry {
    private final PluginManager pluginManager;
    private final PluginDescriptionFile pluginDescription;
    private final ExtendedLogger logger;
    private final RewardManager rewardManager;

    public void init() {
        this.tryEnable("PlaceholderAPI", () -> new PlaceholderAPIIntegration(this.rewardManager, this.pluginDescription).enable());
    }

    private void tryEnable(String pluginName, Integration integration) {
        if (this.pluginManager.isPluginEnabled(pluginName)) {
            try {
                integration.enable();
                this.logger.info("Enabled integration " + pluginName);
            }
            catch (Exception e) {
                this.logger.error("Failed to enable integration " + pluginName);
                e.printStackTrace();
            }
        }
    }

    @Inject
    @Generated
    public IntegrationRegistry(PluginManager pluginManager, PluginDescriptionFile pluginDescription, ExtendedLogger logger, RewardManager rewardManager) {
        this.pluginManager = pluginManager;
        this.pluginDescription = pluginDescription;
        this.logger = logger;
        this.rewardManager = rewardManager;
    }
}

