/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.ndailyrewards.database.clients;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.jdbc.DataSourceConnectionSource;
import com.j256.ormlite.support.ConnectionSource;
import com.zaxxer.hikari.HikariDataSource;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.bukkit.plugin.Plugin;
import org.bxteam.ndailyrewards.database.DatabaseClient;

@Singleton
public class SQLiteClient
implements DatabaseClient {
    private final Plugin plugin;
    private final Map<Class<?>, Dao<?, ?>> cachedDao = new ConcurrentHashMap();
    private final Path dataDirectory;
    private HikariDataSource dataSource;
    private ConnectionSource connectionSource;

    @Inject
    public SQLiteClient(@Named(value="dataFolder") Path dataDirectory, Plugin plugin) {
        this.dataDirectory = dataDirectory;
        this.plugin = plugin;
    }

    @Override
    public void open() throws SQLException {
        this.dataSource = new HikariDataSource();
        this.dataSource.addDataSourceProperty("cachePrepStmts", (Object)true);
        this.dataSource.addDataSourceProperty("prepStmtCacheSize", (Object)250);
        this.dataSource.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)2048);
        this.dataSource.addDataSourceProperty("useServerPrepStmts", (Object)true);
        this.dataSource.setMaximumPoolSize(5);
        this.dataSource.setPoolName("NDailyRewards");
        this.dataSource.setDriverClassName("org.sqlite.JDBC");
        this.dataSource.setJdbcUrl("jdbc:sqlite:" + String.valueOf(this.dataDirectory.toAbsolutePath()) + "/" + this.plugin.getConfig().getString("database.sqlite.file"));
        this.connectionSource = new DataSourceConnectionSource((DataSource)this.dataSource, this.dataSource.getJdbcUrl());
    }

    @Override
    public void close() {
        try {
            this.dataSource.close();
            this.connectionSource.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean available() {
        boolean bl;
        block8: {
            Connection connection = this.dataSource.getConnection();
            try {
                bl = connection.isValid(2);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    return false;
                }
            }
            connection.close();
        }
        return bl;
    }

    @Override
    public ConnectionSource getConnectionSource() {
        return this.connectionSource;
    }

    @Override
    public <T, ID> Dao<T, ID> getDao(Class<T> type) {
        try {
            Dao dao = this.cachedDao.get(type);
            if (dao == null) {
                dao = DaoManager.createDao((ConnectionSource)this.connectionSource, type);
                this.cachedDao.put(type, dao);
            }
            return dao;
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }
}

