/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.ndailyrewards.command;

import com.google.inject.Inject;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bxteam.commons.updater.VersionFetcher;
import org.bxteam.ndailyrewards.configuration.Language;
import org.bxteam.ndailyrewards.utils.TextUtils;
import revxrsal.commands.annotation.Command;
import revxrsal.commands.annotation.Subcommand;
import revxrsal.commands.bukkit.annotation.CommandPermission;

@Command(value={"reward", "rw", "ndailyrewards", "ndr"})
public class VersionCommand {
    private final PluginDescriptionFile pluginDescription;
    private final VersionFetcher versionFetcher;

    @Subcommand(value={"version"})
    @CommandPermission(value="ndailyrewards.version")
    void version(CommandSender sender) {
        ComparableVersion current = new ComparableVersion(this.pluginDescription.getVersion());
        sender.sendMessage(Language.PREFIX.asColoredString() + TextUtils.applyColor("&aCurrent installed version: &e" + String.valueOf(current)));
        ((CompletableFuture)CompletableFuture.supplyAsync(this.versionFetcher::fetchNewestVersion).thenApply(Objects::requireNonNull)).whenComplete((newest, error) -> {
            if (error != null || newest.compareTo(current) <= 0) {
                return;
            }
            sender.sendMessage(Language.PREFIX.asColoredString() + TextUtils.applyColor("&aA new update is available: &e" + String.valueOf(newest)));
            sender.sendMessage(Language.PREFIX.asColoredString() + TextUtils.applyColor("&aDownload here: &e" + this.versionFetcher.getDownloadUrl()));
        });
    }

    @Inject
    @Generated
    public VersionCommand(PluginDescriptionFile pluginDescription, VersionFetcher versionFetcher) {
        this.pluginDescription = pluginDescription;
        this.versionFetcher = versionFetcher;
    }
}

