/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.ndailyrewards;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.j256.ormlite.logger.Level;
import com.j256.ormlite.logger.Logger;
import java.io.File;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bxteam.commons.logger.ExtendedLogger;
import org.bxteam.commons.logger.LogEntry;
import org.bxteam.commons.logger.LogLevel;
import org.bxteam.commons.logger.appender.ConsoleAppender;
import org.bxteam.commons.logger.appender.JsonAppender;
import org.bxteam.commons.scheduler.Scheduler;
import org.bxteam.commons.updater.VersionFetcher;
import org.bxteam.ndailyrewards.NDailyRewardsModule;
import org.bxteam.ndailyrewards.configuration.Language;
import org.bxteam.ndailyrewards.database.DatabaseClient;
import org.bxteam.ndailyrewards.database.DatabaseModule;
import org.bxteam.ndailyrewards.dependencies.bstats.bukkit.Metrics;
import org.bxteam.ndailyrewards.integration.IntegrationRegistry;
import org.bxteam.ndailyrewards.listener.InventoryClickListener;
import org.bxteam.ndailyrewards.listener.PlayerJoinListener;
import org.bxteam.ndailyrewards.manager.CommandManager;
import org.bxteam.ndailyrewards.manager.menu.MenuManager;
import org.bxteam.ndailyrewards.manager.reward.RewardManager;
import org.bxteam.ndailyrewards.scheduler.SchedulerSetup;
import org.bxteam.ndailyrewards.utils.LibraryLoaderUtil;

public final class NDailyRewards
extends JavaPlugin {
    private Injector injector;
    private ExtendedLogger logger;
    private File langFile;
    private FileConfiguration langConfig;
    private CommandManager commandManager;

    public FileConfiguration getLangConfig() {
        return this.langConfig;
    }

    public void onLoad() {
        LibraryLoaderUtil.loadDependencies(this);
    }

    public void onEnable() {
        Instant startTime = Instant.now();
        ConsoleAppender consoleAppender = new ConsoleAppender("[{loggerName}] {logLevel}: {message}");
        String date = new SimpleDateFormat("yyyy-MM-dd").format(new Date(System.currentTimeMillis()));
        File logsFile = new File("plugins/NDailyRewards/logs/ndr-logs-" + date + ".txt");
        if (!logsFile.exists()) {
            try {
                logsFile.getParentFile().mkdirs();
                logsFile.createNewFile();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        JsonAppender jsonAppender = new JsonAppender(false, false, true, logsFile.getPath());
        this.logger = new ExtendedLogger("NDailyRewards", LogLevel.INFO, List.of(consoleAppender, jsonAppender), new ArrayList<Function<LogEntry, Boolean>>());
        this.injector = Guice.createInjector((Module[])new Module[]{new NDailyRewardsModule((Plugin)this, this.logger), new DatabaseModule((Plugin)this), new SchedulerSetup((Plugin)this)});
        this.saveDefaultConfig();
        this.createLangFile();
        Language.init(this);
        new Metrics((Plugin)this, 13844);
        this.logger.info("Loading plugin managers...");
        Logger.setGlobalLogLevel((Level)Level.ERROR);
        try {
            ((DatabaseClient)this.injector.getInstance(DatabaseClient.class)).open();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        ((IntegrationRegistry)this.injector.getInstance(IntegrationRegistry.class)).init();
        this.injector.getInstance(RewardManager.class);
        this.injector.getInstance(MenuManager.class);
        this.logger.info("Registering listeners...");
        this.getServer().getPluginManager().registerEvents((Listener)this.injector.getInstance(InventoryClickListener.class), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.injector.getInstance(PlayerJoinListener.class), (Plugin)this);
        this.commandManager = new CommandManager(this, this.injector);
        this.commandManager.registerCommands();
        Duration timeTaken = Duration.between(startTime, Instant.now());
        this.logger.info("Successfully enabled (took %sms)".formatted(timeTaken.toMillis()));
        if (this.getConfig().getBoolean("check-updates")) {
            this.checkForUpdates();
        }
    }

    public void onDisable() {
        ((Scheduler)this.injector.getInstance(Scheduler.class)).cancelTasks((Plugin)this);
        this.commandManager.unregisterCommands();
        ((DatabaseClient)this.injector.getInstance(DatabaseClient.class)).close();
        ((MenuManager)this.injector.getInstance(MenuManager.class)).shutdown();
        ((RewardManager)this.injector.getInstance(RewardManager.class)).unload();
    }

    public void reload() {
        this.reloadConfig();
        this.createLangFile();
        Language.init(this);
    }

    private void createLangFile() {
        this.langFile = new File(this.getDataFolder(), "lang.yml");
        if (!this.langFile.exists()) {
            this.langFile.getParentFile().mkdirs();
            this.saveResource("lang.yml", false);
        }
        this.langConfig = YamlConfiguration.loadConfiguration((File)this.langFile);
    }

    private void checkForUpdates() {
        ComparableVersion current = new ComparableVersion(this.getDescription().getVersion());
        ((CompletableFuture)CompletableFuture.supplyAsync(((VersionFetcher)this.injector.getInstance(VersionFetcher.class))::fetchNewestVersion).thenApply(Objects::requireNonNull)).whenComplete((newest, error) -> {
            if (error != null || newest.compareTo(current) <= 0) {
                return;
            }
            this.logger.warn("A new version of NDailyRewards is available!\nYour version: %s\nNewest version: %s\nDownload it at: %s\n".formatted(current.toString(), newest, ((VersionFetcher)this.injector.getInstance(VersionFetcher.class)).getDownloadUrl()));
        });
    }
}

