/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.commons.scheduler;

import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bxteam.commons.scheduler.Task;

public interface Scheduler {
    public boolean isGlobalThread();

    default public boolean isTickThread() {
        return Bukkit.getServer().isPrimaryThread();
    }

    public boolean isEntityThread(Entity var1);

    public boolean isRegionThread(Location var1);

    public Task runTask(Runnable var1);

    public Task runTaskLater(Runnable var1, long var2);

    public Task runTaskTimer(Runnable var1, long var2, long var4);

    default public Task runTask(Location location, Runnable runnable) {
        return this.runTask(runnable);
    }

    default public Task runTaskLater(Location location, Runnable runnable, long delay) {
        return this.runTaskLater(runnable, delay);
    }

    default public Task runTaskTimer(Location location, Runnable runnable, long delay, long period) {
        return this.runTaskTimer(runnable, delay, period);
    }

    default public Task runTask(Entity entity, Runnable runnable) {
        return this.runTask(runnable);
    }

    default public Task runTaskLater(Entity entity, Runnable runnable, long delay) {
        return this.runTaskLater(runnable, delay);
    }

    default public Task runTaskTimer(Entity entity, Runnable runnable, long delay, long period) {
        return this.runTaskTimer(runnable, delay, period);
    }

    public Task runTaskAsynchronously(Runnable var1);

    public Task runTaskLaterAsynchronously(Runnable var1, long var2);

    public Task runTaskTimerAsynchronously(Runnable var1, long var2, long var4);

    default public <T> Future<T> callSyncMethod(Callable<T> task) {
        CompletableFuture completableFuture = new CompletableFuture();
        this.execute(() -> {
            try {
                completableFuture.complete(task.call());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return completableFuture;
    }

    public void execute(Runnable var1);

    default public void execute(Location location, Runnable runnable) {
        this.execute(runnable);
    }

    default public void execute(Entity entity, Runnable runnable) {
        this.execute(runnable);
    }

    public void cancelTasks();

    public void cancelTasks(Plugin var1);
}

