/*
 * Decompiled with CFR 0.152.
 */
package org.bxteam.commons.logger.appender;

import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import org.bxteam.commons.logger.LogEntry;
import org.bxteam.commons.logger.appender.Appender;
import org.jetbrains.annotations.NotNull;

public class ConsoleAppender
implements Appender {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final PrintStream out;
    @NotNull
    private final String format;

    public ConsoleAppender(@NotNull String format) {
        this.format = format;
        this.out = new PrintStream(new OutputStream(){

            @Override
            public void write(int b) {
                System.out.write(b);
            }
        });
    }

    public ConsoleAppender() {
        this("[{loggerName}] {timestamp} {logLevel}: {message}");
    }

    @Override
    public void append(LogEntry logEntry) {
        Object message = this.format.replace("{loggerName}", logEntry.loggerName()).replace("{timestamp}", sdf.format(logEntry.timestamp())).replace("{threadName}", logEntry.threadName()).replace("{logLevel}", logEntry.logLevel().name()).replace("{message}", logEntry.message());
        if (logEntry.throwable() != null) {
            message = (String)message + "\n" + String.valueOf(logEntry.throwable());
        }
        this.out.println((String)message);
    }

    @Override
    public void close() {
    }
}

