/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_8.utils;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Objects;

public class FieldUtils {
    private static final int ACCESS_TEST = 7;
    public static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Method IS_SYNTHETIC;

    public static Object readDeclaredField(Object target, String fieldName, boolean forceAccess) throws IllegalAccessException {
        if (target == null) {
            throw new IllegalArgumentException("target object must not be null");
        }
        Class<?> cls = target.getClass();
        Field field = FieldUtils.getDeclaredField(cls, fieldName, forceAccess);
        if (field == null) {
            throw new IllegalArgumentException("Cannot locate declared field " + cls.getName() + "." + fieldName);
        }
        return FieldUtils.readField(field, target, false);
    }

    public static Field getDeclaredField(Class cls, String fieldName, boolean forceAccess) {
        if (cls == null) {
            throw new IllegalArgumentException("The class must not be null");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("The field name must not be null");
        }
        try {
            Field field = cls.getDeclaredField(fieldName);
            if (!FieldUtils.isAccessible(field)) {
                if (forceAccess) {
                    field.setAccessible(true);
                } else {
                    return null;
                }
            }
            return field;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    public static Object readField(Field field, Object target, boolean forceAccess) throws IllegalAccessException {
        if (field == null) {
            throw new IllegalArgumentException("The field must not be null");
        }
        if (forceAccess && !field.isAccessible()) {
            field.setAccessible(true);
        } else {
            FieldUtils.setAccessibleWorkaround(field);
        }
        return field.get(target);
    }

    static boolean isAccessible(Member m) {
        return m != null && Modifier.isPublic(m.getModifiers()) && !FieldUtils.isSynthetic(m);
    }

    static boolean isSynthetic(Member m) {
        if (IS_SYNTHETIC != null) {
            try {
                return (Boolean)IS_SYNTHETIC.invoke((Object)m, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    static void setAccessibleWorkaround(AccessibleObject o) {
        if (o == null || o.isAccessible()) {
            return;
        }
        Member m = (Member)((Object)o);
        if (Modifier.isPublic(m.getModifiers()) && FieldUtils.isPackageAccess(m.getDeclaringClass().getModifiers())) {
            try {
                o.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    static boolean isPackageAccess(int modifiers) {
        return (modifiers & 7) == 0;
    }

    public static void writeDeclaredField(Object target, String fieldName, Object value, boolean forceAccess) throws IllegalAccessException {
        Objects.requireNonNull(target, "target object must not be null");
        Class<?> cls = target.getClass();
        Field field = FieldUtils.getDeclaredField(cls, fieldName, forceAccess);
        Objects.requireNonNull(field, "Cannot locate declared field %s.%s");
        FieldUtils.writeField(field, target, value, false);
    }

    public static void writeField(Field field, Object target, Object value, boolean forceAccess) throws IllegalAccessException {
        Objects.requireNonNull(field, "The field must not be null");
        if (forceAccess && !field.isAccessible()) {
            field.setAccessible(true);
        } else {
            FieldUtils.setAccessibleWorkaround(field);
        }
        field.set(target, value);
    }

    static {
        Method isSynthetic = null;
        try {
            isSynthetic = Member.class.getMethod("isSynthetic", EMPTY_CLASS_ARRAY);
        }
        catch (Exception exception) {
            // empty catch block
        }
        IS_SYNTHETIC = isSynthetic;
    }
}

