/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_8.entity.special;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import simplepets.brainsynder.api.entity.IEntityPet;
import simplepets.brainsynder.api.entity.misc.IEntityControllerPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.sounds.SoundMaker;
import simplepets.brainsynder.versions.v1_21_8.entity.list.EntityArmorStandPet;
import simplepets.brainsynder.versions.v1_21_8.entity.list.EntityShulkerPet;
import simplepets.brainsynder.versions.v1_21_8.entity.list.EntityZombiePet;
import simplepets.brainsynder.versions.v1_21_8.entity.special.EntityGhostStand;
import simplepets.brainsynder.versions.v1_21_8.helper.VersionHelper;

public class EntityControllerPet
extends EntityZombiePet
implements IEntityControllerPet {
    private final LinkedList<Entity> ENTITIES = new LinkedList();
    private final EntityLiving PET;
    private Entity displayEntity;
    private Entity displayRider = null;

    public EntityControllerPet(PetType type, PetUser user, Location location) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.bQ, type, user);
        this.setDisplayName(false);
        this.ENTITIES.addLast(this.getEntity());
        switch (type) {
            case ARMOR_STAND: {
                this.PET = EntityArmorStandPet.spawn(location, this);
                this.ENTITIES.addLast((Entity)this.PET.getBukkitEntity());
                this.displayEntity = this.PET.getBukkitEntity();
                break;
            }
            case SHULKER: {
                EntityGhostStand ghostStand = EntityGhostStand.spawn(location, this);
                ghostStand.u(true);
                ghostStand.g(true);
                CraftEntity ghost = ghostStand.getBukkitEntity();
                this.ENTITIES.addLast((Entity)ghost);
                this.PET = EntityShulkerPet.spawn(location, this, ghostStand);
                this.PET.collides = false;
                CraftEntity shulker = this.PET.getBukkitEntity();
                ghost.addPassenger((Entity)shulker);
                this.ENTITIES.addLast((Entity)shulker);
                this.displayRider = shulker;
                this.displayEntity = ghost;
                break;
            }
            default: {
                throw new IllegalStateException("This pet does not use controller pets!");
            }
        }
        this.ENTITIES.forEach(entity -> entity.setInvulnerable(true));
        this.collides = false;
    }

    @Override
    public void X() {
        if (this.isPetSilent()) {
            return;
        }
        SimplePets.getPetConfigManager().getPetConfig(this.getPetType()).ifPresent(config -> {
            SoundMaker sound = config.getSound();
            if (sound != null) {
                sound.playSound(this.getEntity());
            }
        });
    }

    @Override
    public List<Entity> getEntities() {
        return this.ENTITIES;
    }

    @Override
    public StorageTagCompound asCompound() {
        return super.asCompound();
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        super.applyCompound(object);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void g() {
        super.g();
        if (this.cP()) {
            this.p(false);
        }
        if (!this.cs()) {
            this.l(true);
        }
        if (!this.be()) {
            this.f(true);
        }
        if (!this.g_() && this.getPetType() == PetType.SHULKER) {
            this.a(this.getPetType() == PetType.SHULKER);
        }
        Player p = this.getPetUser().getPlayer();
        if (this.displayEntity == null || this.displayEntity.isDead() || !this.displayEntity.isValid()) {
            this.displayEntity = null;
            VersionHelper.killEntity((net.minecraft.world.entity.Entity)this, (WorldServer)this.ai());
            return;
        }
        if (this.displayRider != null) {
            if (!this.displayRider.isValid()) {
                this.displayEntity = null;
                VersionHelper.killEntity((net.minecraft.world.entity.Entity)this, (WorldServer)this.ai());
                return;
            }
            entity = VersionHelper.getEntityHandle(this.displayRider);
            this.updateName((net.minecraft.world.entity.Entity)entity);
            if (!this.canIgnoreVanish() && VersionHelper.getEntityHandle((Entity)p).cs() != entity.cs()) {
                entity.l(!entity.cs());
            }
        } else if (this.displayEntity != null) {
            if (!this.displayEntity.isValid()) {
                this.displayEntity = null;
                VersionHelper.killEntity((net.minecraft.world.entity.Entity)this, (WorldServer)this.ai());
                return;
            }
            entity = VersionHelper.getEntityHandle(this.displayEntity);
            if (!this.displayEntity.getPassengers().isEmpty()) {
                if (this.displayRider == null) {
                    this.displayRider = (Entity)this.displayEntity.getPassengers().get(0);
                }
                entity = VersionHelper.getEntityHandle(this.displayRider);
            }
            this.updateName((net.minecraft.world.entity.Entity)entity);
            if (this.canIgnoreVanish()) {
                // empty if block
            }
        }
        double current = this.h(GenericAttributes.w).g();
        if (this.isOwnerRiding()) {
            if (current == this.rideSpeed) return;
            this.h(GenericAttributes.w).a(this.rideSpeed);
            return;
        }
        if (current == this.walkSpeed) return;
        this.h(GenericAttributes.w).a(this.walkSpeed);
    }

    public EnumInteractionResult a(EntityHuman entityhuman, Vec3D vec3d, EnumHand enumhand) {
        return EnumInteractionResult.d;
    }

    @Override
    public void a(EnumMoveType enummovetype, Vec3D vec3d) {
        super.a(enummovetype, vec3d);
        if (this.displayEntity == null) {
            return;
        }
        this.reloadLocation();
    }

    public void updateName(net.minecraft.world.entity.Entity entity) {
        if (!entity.cP()) {
            entity.p(true);
        }
        if (this.i_() && !this.al().equals((Object)entity.al())) {
            entity.b(this.al());
        }
    }

    @Override
    protected boolean isOwnerRiding() {
        if (this.displayEntity == null || this.getVisibleEntity() == null) {
            return false;
        }
        if (this.getVisibleEntity().getPetUser() == null) {
            return false;
        }
        if (this.displayEntity.getPassengers().size() == 0) {
            return false;
        }
        EntityPlayer owner = (EntityPlayer)VersionHelper.getEntityHandle((Entity)this.getVisibleEntity().getPetUser().getPlayer());
        for (Entity passenger : this.displayEntity.getPassengers()) {
            if (!passenger.getUniqueId().equals(owner.cK())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Optional<Entity> getDisplayEntity() {
        return Optional.of(this.displayEntity);
    }

    @Override
    public Optional<Entity> getDisplayRider() {
        return Optional.of(this.displayRider);
    }

    @Override
    public void setDisplayEntity(Entity entity) {
    }

    @Override
    public void remove() {
        this.getBukkitEntity().remove();
        for (Entity ent : this.ENTITIES) {
            ent.remove();
        }
        this.displayEntity = null;
        this.displayRider = null;
    }

    @Override
    public void reloadLocation() {
        if (this.displayEntity.getPassenger() != null) {
            Object displayEntity = VersionHelper.getEntityHandle(this.displayEntity);
            Location loc = this.displayRider != null ? (this.getPetType() == PetType.SHULKER ? this.getBukkitEntity().getLocation().clone().subtract(0.0, 0.735, 0.0) : this.getBukkitEntity().getLocation().clone()) : this.getBukkitEntity().getLocation().clone();
            VersionHelper.moveTo(displayEntity, loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
            loc.getWorld().getNearbyEntities(loc, 100.0, 100.0, 100.0).forEach(entity -> {
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    PacketPlayOutEntityTeleport packet = VersionHelper.getTeleportPacket(displayEntity);
                    ((EntityPlayer)VersionHelper.getEntityHandle((Entity)player)).g.b((Packet)packet);
                }
            });
            return;
        }
        Object displayEntity = VersionHelper.getEntityHandle(this.displayEntity);
        Location loc = this.displayRider != null ? (this.displayRider.getType().equals((Object)EntityTypes.be) ? this.getBukkitEntity().getLocation().clone().add(0.0, 0.75, 0.0) : this.getBukkitEntity().getLocation().clone()) : this.getBukkitEntity().getLocation().clone();
        VersionHelper.moveTo(displayEntity, loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
        loc.getWorld().getNearbyEntities(loc, 100.0, 100.0, 100.0).forEach(entity -> {
            if (entity instanceof Player) {
                Player player = (Player)entity;
                PacketPlayOutEntityTeleport packet = VersionHelper.getTeleportPacket(displayEntity);
                ((EntityPlayer)VersionHelper.getEntityHandle((Entity)player)).g.b((Packet)packet);
            }
        });
    }

    @Override
    public void addPassenger(Entity passenger) {
        ((net.minecraft.world.entity.Entity)VersionHelper.getEntityHandle((Entity)passenger)).aR.add(0, (Object)this);
    }

    @Override
    public boolean isMoving() {
        return false;
    }

    @Override
    public void updateName() {
    }

    @Override
    public IEntityPet getVisibleEntity() {
        Optional<Object> displayOption1;
        if (this.displayEntity == null) {
            this.remove();
            return this;
        }
        Optional<Object> displayOption = SimplePets.getSpawnUtil().getHandle(this.displayEntity);
        if (displayOption.isPresent() && displayOption.get() instanceof IEntityPet) {
            return (IEntityPet)displayOption.get();
        }
        if (this.displayEntity.getPassenger() != null && (displayOption1 = SimplePets.getSpawnUtil().getHandle(this.displayEntity.getPassenger())).isPresent() && displayOption1.get() instanceof IEntityPet) {
            return (IEntityPet)displayOption1.get();
        }
        if (this.displayRider != null && (displayOption1 = SimplePets.getSpawnUtil().getHandle(this.displayRider)).isPresent() && displayOption1.get() instanceof IEntityPet) {
            return (IEntityPet)displayOption1.get();
        }
        return this;
    }
}

