/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_8.entity.list;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftVillager;
import org.bukkit.entity.Villager;
import simplepets.brainsynder.api.entity.hostile.IEntityZombieVillagerPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.api.wrappers.villager.BiomeType;
import simplepets.brainsynder.api.wrappers.villager.VillagerInfo;
import simplepets.brainsynder.api.wrappers.villager.VillagerLevel;
import simplepets.brainsynder.api.wrappers.villager.VillagerType;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_8.entity.list.EntityZombiePet;
import simplepets.brainsynder.versions.v1_21_8.utils.PetDataAccess;

public class EntityZombieVillagerPet
extends EntityZombiePet
implements IEntityZombieVillagerPet {
    private static final DataWatcherObject<Boolean> CONVERTING = DataWatcher.a(EntityZombieVillagerPet.class, (DataWatcherSerializer)DataWatcherRegistry.k);
    private static final DataWatcherObject<VillagerData> VILLAGER_DATA = DataWatcher.a(EntityZombieVillagerPet.class, (DataWatcherSerializer)DataWatcherRegistry.u);

    public EntityZombieVillagerPet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.bS, type, user);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("raised-arms", this.isArmsRaised());
        data.add("shaking", this.isShaking());
        data.add("profession", this.getVillagerType().name());
        data.add("biome", this.getBiome().name());
        data.add("level", this.getMasteryLevel().name());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(CONVERTING, false);
        dataAccess.define(VILLAGER_DATA, new VillagerData((Holder)BuiltInRegistries.w.b(net.minecraft.world.entity.npc.VillagerType.c), (Holder)BuiltInRegistries.x.b(VillagerProfession.b), 1));
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        object.setBoolean("raised_arms", this.isArmsRaised());
        object.setBoolean("shaking", this.isShaking());
        object.setTag("data", this.getVillagerData().toCompound());
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("data")) {
            this.setVillagerData(VillagerInfo.fromCompound(object.getCompoundTag("data")));
        }
        if (object.hasKey("raised_arms")) {
            this.setArmsRaised(object.getBoolean("raised_arms"));
        }
        if (object.hasKey("profession")) {
            this.setVillagerType(object.getEnum("profession", VillagerType.class, VillagerType.NONE));
        }
        if (object.hasKey("biome")) {
            this.setBiome(object.getEnum("biome", BiomeType.class, BiomeType.PLAINS));
        }
        if (object.hasKey("level")) {
            this.setMasteryLevel(object.getEnum("level", VillagerLevel.class, VillagerLevel.NOVICE));
        }
        super.applyCompound(object);
    }

    @Override
    public boolean isShaking() {
        return (Boolean)this.ay.a(CONVERTING);
    }

    @Override
    public void setShaking(boolean value) {
        this.ay.a(CONVERTING, (Object)value);
    }

    private VillagerData getRawData() {
        return (VillagerData)this.ay.a(VILLAGER_DATA);
    }

    @Override
    public VillagerInfo getVillagerData() {
        VillagerData raw = this.getRawData();
        return new VillagerInfo(BiomeType.valueOf(CraftVillager.CraftType.minecraftHolderToBukkit((Holder)raw.a()).name()), VillagerType.valueOf(CraftVillager.CraftProfession.minecraftHolderToBukkit((Holder)raw.b()).name()), VillagerLevel.getById(raw.c()));
    }

    @Override
    public void setVillagerData(VillagerInfo data) {
        this.ay.a(VILLAGER_DATA, (Object)new VillagerData(CraftVillager.CraftType.bukkitToMinecraftHolder((Villager.Type)Villager.Type.valueOf((String)data.getBiome().name())), CraftVillager.CraftProfession.bukkitToMinecraftHolder((Villager.Profession)Villager.Profession.valueOf((String)data.getType().name())), data.getLevel().ordinal() + 1));
    }
}

