/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_8.entity.list;

import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import simplepets.brainsynder.api.entity.passive.IEntitySnifferPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.api.wrappers.SnifferState;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_8.entity.EntityAgeablePet;
import simplepets.brainsynder.versions.v1_21_8.utils.PetDataAccess;

public class EntitySnifferPet
extends EntityAgeablePet
implements IEntitySnifferPet {
    private static final DataWatcherObject<Sniffer.State> DATA_STATE = DataWatcher.a(EntitySnifferPet.class, (DataWatcherSerializer)DataWatcherRegistry.G);
    private static final DataWatcherObject<Integer> DATA_DROP_SEED_AT_TICK = DataWatcher.a(EntitySnifferPet.class, (DataWatcherSerializer)DataWatcherRegistry.b);
    private SnifferState state = SnifferState.IDLING;

    public EntitySnifferPet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.bl, type, user);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("state", this.getSnifferState().name());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(DATA_STATE, Sniffer.State.a);
        dataAccess.define(DATA_DROP_SEED_AT_TICK, 0);
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        object.setEnum("state", this.getSnifferState());
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("state")) {
            this.setSnifferState(object.getEnum("state", SnifferState.class, SnifferState.IDLING));
        }
        super.applyCompound(object);
    }

    @Override
    public SnifferState getSnifferState() {
        return this.state;
    }

    @Override
    public void setSnifferState(SnifferState state) {
        this.state = state;
        this.transitionTo(state);
    }

    private void setState(SnifferState state) {
        Sniffer.State sniffer_state = Sniffer.State.valueOf((String)state.name());
        this.ay.a(DATA_STATE, (Object)sniffer_state);
    }

    public void transitionTo(SnifferState state) {
        switch (state) {
            case IDLING: {
                this.setState(SnifferState.IDLING);
                break;
            }
            case FEELING_HAPPY: {
                this.a(SoundEffects.zZ, 1.0f, 1.0f);
                this.setState(SnifferState.FEELING_HAPPY);
                break;
            }
            case SCENTING: {
                this.setState(SnifferState.SCENTING);
                this.a(SoundEffects.zU, 1.0f, this.g_() ? 1.3f : 1.0f);
                break;
            }
            case SNIFFING: {
                this.a(SoundEffects.zV, 1.0f, 1.0f);
                this.setState(SnifferState.SNIFFING);
                break;
            }
            case DIGGING: {
                this.setState(SnifferState.DIGGING);
                this.ay.a(DATA_DROP_SEED_AT_TICK, (Object)(this.as + 120));
                this.ai().a((Entity)this, (byte)63);
            }
        }
    }
}

