/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_7.entity.list;

import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.Items;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import simplepets.brainsynder.api.entity.hostile.IEntityWitchPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.math.MathUtils;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_7.entity.branch.EntityRaiderPet;
import simplepets.brainsynder.versions.v1_21_7.utils.PetDataAccess;

public class EntityWitchPet
extends EntityRaiderPet
implements IEntityWitchPet {
    private static final DataWatcherObject<Boolean> IS_DRINKING = DataWatcher.a(EntityWitchPet.class, (DataWatcherSerializer)DataWatcherRegistry.k);

    public EntityWitchPet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.bK, type, user);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("drinking-potion", this.isDrinkingPotion());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(IS_DRINKING, Boolean.FALSE);
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        object.setBoolean("potion", this.isDrinkingPotion());
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("potion")) {
            this.setDrinkingPotion(object.getBoolean("potion"));
        }
        super.applyCompound(object);
    }

    @Override
    public void setDrinkingPotion(boolean flag) {
        this.ay.a(IS_DRINKING, (Object)flag);
        if (flag) {
            ItemStack item = new ItemStack(Material.POTION);
            PotionMeta meta = (PotionMeta)item.getItemMeta();
            meta.setColor(Color.fromRGB((int)MathUtils.random(0, 255), (int)MathUtils.random(0, 255), (int)MathUtils.random(0, 255)));
            item.setItemMeta((ItemMeta)meta);
            this.a(EnumItemSlot.a, CraftItemStack.asNMSCopy((ItemStack)item));
        } else {
            this.a(EnumItemSlot.a, Items.a.m());
        }
    }

    @Override
    public boolean isDrinkingPotion() {
        return (Boolean)this.ay.a(IS_DRINKING);
    }
}

