/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_7.entity.list;

import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.CatVariants;
import org.bukkit.craftbukkit.v1_21_R5.CraftRegistry;
import simplepets.brainsynder.api.entity.passive.IEntityCatPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.api.wrappers.CatType;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.utils.DyeColorWrapper;
import simplepets.brainsynder.versions.v1_21_7.entity.EntityTameablePet;
import simplepets.brainsynder.versions.v1_21_7.helper.VersionHelper;
import simplepets.brainsynder.versions.v1_21_7.utils.PetDataAccess;
import simplepets.brainsynder.versions.v1_21_7.utils.VariantUtils;

public class EntityCatPet
extends EntityTameablePet
implements IEntityCatPet {
    private static final DataWatcherObject<Holder<CatVariant>> TYPE = DataWatcher.a(EntityCatPet.class, (DataWatcherSerializer)DataWatcherRegistry.x);
    private static final DataWatcherObject<Boolean> SLEEPING_WITH_OWNER = DataWatcher.a(EntityCatPet.class, (DataWatcherSerializer)DataWatcherRegistry.k);
    private static final DataWatcherObject<Boolean> HEAD_UP = DataWatcher.a(EntityCatPet.class, (DataWatcherSerializer)DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> COLLAR_COLOR = DataWatcher.a(EntityCatPet.class, (DataWatcherSerializer)DataWatcherRegistry.b);
    private CatType type = CatType.TABBY;

    public EntityCatPet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.v, type, user);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("type", this.getCatType().name());
        data.add("collar", this.getCollarColor().name());
        data.add("sleeping", this.isPetSleeping());
        data.add("head-up", this.isHeadUp());
        data.add("tamed", this.isTamed());
        data.add("sitting", this.isSitting());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(TYPE, VariantUtils.getDefaultOrAny(this.eb(), CatVariants.a));
        dataAccess.define(SLEEPING_WITH_OWNER, false);
        dataAccess.define(HEAD_UP, false);
        dataAccess.define(COLLAR_COLOR, DyeColorWrapper.WHITE.getWoolData());
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound compound = super.asCompound();
        compound.setEnum("type", this.getCatType());
        compound.setEnum("collar", this.getCollarColor());
        compound.setBoolean("sleeping", this.isPetSleeping());
        compound.setBoolean("head_up", this.isHeadUp());
        return compound;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("type")) {
            this.setCatType(object.getEnum("type", CatType.class, CatType.TABBY));
        }
        if (object.hasKey("collar")) {
            this.setCollarColor(object.getEnum("collar", DyeColorWrapper.class, DyeColorWrapper.WHITE));
        }
        if (object.hasKey("sleeping")) {
            this.setPetSleeping(object.getBoolean("sleeping", false));
        }
        if (object.hasKey("head_up")) {
            this.setHeadUp(object.getBoolean("head_up", false));
        }
        super.applyCompound(object);
    }

    @Override
    public CatType getCatType() {
        return this.type;
    }

    @Override
    public void setCatType(CatType type) {
        this.type = type;
        IRegistry registry = CraftRegistry.getMinecraftRegistry((ResourceKey)Registries.aL);
        this.ay.a(TYPE, (Object)registry.e((Object)((CatVariant)VersionHelper.getRegistryValue(registry, type.getKey()))));
    }

    @Override
    public DyeColorWrapper getCollarColor() {
        return DyeColorWrapper.getByWoolData((byte)((Integer)this.ay.a(COLLAR_COLOR)).intValue());
    }

    @Override
    public void setCollarColor(DyeColorWrapper color) {
        this.ay.a(COLLAR_COLOR, (Object)color.ordinal());
    }

    @Override
    public boolean isHeadUp() {
        return (Boolean)this.ay.a(HEAD_UP);
    }

    @Override
    public void setHeadUp(boolean value) {
        this.ay.a(HEAD_UP, (Object)value);
    }

    @Override
    public boolean isPetSleeping() {
        return (Boolean)this.ay.a(SLEEPING_WITH_OWNER);
    }

    @Override
    public void setPetSleeping(boolean sleeping) {
        this.ay.a(SLEEPING_WITH_OWNER, (Object)sleeping);
    }
}

