/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_7.entity.list;

import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import simplepets.brainsynder.api.entity.hostile.IEntityBlazePet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_7.entity.EntityFlyablePet;
import simplepets.brainsynder.versions.v1_21_7.utils.PetDataAccess;

public class EntityBlazePet
extends EntityFlyablePet
implements IEntityBlazePet {
    private static final DataWatcherObject<Byte> ON_FIRE = DataWatcher.a(EntityBlazePet.class, (DataWatcherSerializer)DataWatcherRegistry.a);

    public EntityBlazePet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.p, type, user);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        data.add("burning", this.isBurning());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(ON_FIRE, (byte)0);
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        object.setBoolean("burning", this.isBurning());
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("burning")) {
            this.setBurning(object.getBoolean("burning"));
        }
        super.applyCompound(object);
    }

    @Override
    public void setBurning(boolean var) {
        byte b1 = (Byte)this.ay.a(ON_FIRE);
        b1 = var ? (byte)(b1 | 1) : (byte)(b1 & 0xFFFFFFFE);
        this.ay.a(ON_FIRE, (Object)b1);
    }

    @Override
    public boolean isBurning() {
        return ((Byte)this.ay.a(ON_FIRE) & 1) != 0;
    }
}

