/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_7.entity.list;

import com.mojang.authlib.GameProfile;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.InputMismatchException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.EulerAngle;
import simplepets.brainsynder.PetCore;
import simplepets.brainsynder.api.entity.ambient.IEntityArmorStandPet;
import simplepets.brainsynder.api.entity.misc.IEntityControllerPet;
import simplepets.brainsynder.api.other.ParticleHandler;
import simplepets.brainsynder.api.pet.CommandReason;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.libs.bslib.item.ItemBuilder;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageBase;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagString;
import simplepets.brainsynder.libs.bslib.utils.Base64Wrapper;
import simplepets.brainsynder.versions.v1_21_7.entity.special.EntityControllerPet;
import simplepets.brainsynder.versions.v1_21_7.helper.VersionHelper;

public class EntityArmorStandPet
extends EntityArmorStand
implements IEntityArmorStandPet {
    private boolean isSpecial = false;
    private Map<String, StorageTagCompound> additional;
    private EntityControllerPet pet;
    private Location previus;
    private boolean moving = false;
    private boolean visible = true;
    private boolean store = true;
    private boolean minime = false;
    private boolean frozen = false;
    private boolean isGlowing = false;
    private ChatColor glowColor = ChatColor.WHITE;
    private PetUser user;
    private boolean restricted;
    private final List<ItemStack> cachedItems = new ArrayList<ItemStack>();

    public EntityArmorStandPet(WorldServer world) {
        super(EntityTypes.g, (World)world);
    }

    public EntityArmorStandPet(EntityControllerPet pet, PetUser user) {
        super(EntityTypes.g, pet.ai());
        this.pet = pet;
        this.user = user;
        this.additional = new HashMap<String, StorageTagCompound>();
    }

    @Override
    public void fetchPetDebugInformation(JsonObject debugInfo) {
        debugInfo.set("small", this.isSmallStand());
        debugInfo.set("clone", this.isOwner());
        debugInfo.set("restricted", this.isRestricted());
    }

    public EntityTypes<?> ap() {
        return EntityTypes.g;
    }

    public static EntityArmorStandPet spawn(Location location, EntityControllerPet pet) {
        final EntityArmorStandPet stand = new EntityArmorStandPet(pet, pet.getPetUser());
        stand.a_(location.getX(), location.getY(), location.getZ());
        stand.setBasePlateVisibility(false);
        stand.setArmsVisibile(true);
        stand.n(true);
        stand.persist = true;
        stand.setSpecial(true);
        stand.l(false);
        VersionHelper.addEntity((World)((CraftWorld)location.getWorld()).getHandle(), (net.minecraft.world.entity.Entity)stand, CreatureSpawnEvent.SpawnReason.CUSTOM);
        pet.setIgnoreVanish(true);
        new BukkitRunnable(){

            public void run() {
                stand.getBukkitEntity().setGravity(true);
            }
        }.runTaskLater((Plugin)PetCore.getInstance(), 60L);
        return stand;
    }

    @Override
    public EntityType getPetEntityType() {
        return EntityType.ARMOR_STAND;
    }

    @Override
    public boolean isFrozen() {
        return this.cA();
    }

    @Override
    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
        this.k(frozen ? 150 : 0);
    }

    public void a(EnumMoveType enummovetype, Vec3D vec3d) {
        super.a(enummovetype, vec3d);
    }

    @Override
    public boolean isPetVisible() {
        return this.visible;
    }

    @Override
    public void setPetVisible(boolean visible) {
        this.visible = visible;
        this.l(!visible);
    }

    @Override
    public void setGlowColor(ChatColor glowColor) {
        if (this.glowColor == glowColor) {
            return;
        }
        this.glowColor = glowColor;
    }

    @Override
    public ChatColor getGlowColor() {
        return this.glowColor;
    }

    public void g() {
        String name;
        super.g();
        CraftEntity bukkitEntity = this.getBukkitEntity();
        if (this.pet == null || this.pet.getBukkitEntity().isDead() || !this.pet.getBukkitEntity().isValid()) {
            VersionHelper.killEntity((net.minecraft.world.entity.Entity)this, (WorldServer)this.ai());
            return;
        }
        if (this.user == null || this.user.getPlayer() == null || !this.user.getPlayer().isOnline() || !this.user.hasPet(PetType.ARMOR_STAND)) {
            if (bukkitEntity != null) {
                bukkitEntity.remove();
            }
            return;
        }
        if (this.getPetUser().getPlayer().isValid() && !this.getPetUser().getPlayer().isDead() && this.minime) {
            this.handleCloning();
        }
        if (this.frozen && this.cy() < 140) {
            this.k(150);
        }
        if (this.getEntity().isInsideVehicle()) {
            this.br = this.bt = this.getPetUser().getPlayer().getLocation().getYaw();
            this.setRightLegAngle(new EulerAngle(-1.553343034274955, 0.13962634015954636, 0.0));
            this.setLeftLegAngle(new EulerAngle(-1.5009831567151235, -0.12217304763960307, 0.0));
            return;
        }
        if (this.previus != null) {
            boolean bl = this.moving = this.previus.getX() != this.getEntity().getLocation().getX() || this.previus.getZ() != this.getEntity().getLocation().getZ();
        }
        if (this.store) {
            this.previus = this.getEntity().getLocation();
        }
        boolean bl = this.store = !this.store;
        if (!this.moving) {
            this.setLeftLegAngle(new EulerAngle(0.0, 0.0, 0.0));
            this.setRightLegAngle(new EulerAngle(0.0, 0.0, 0.0));
            this.setLeftArmAngle(new EulerAngle(0.0, 0.0, 0.0));
            this.setRightArmAngle(new EulerAngle(0.0, 0.0, 0.0));
        }
        if (this.pet.g_() != this.isSmallStand()) {
            this.pet.a(this.isSmallStand());
        }
        if (this.cs()) {
            if (!this.isGlowing) {
                this.glowHandler(this.getPetUser().getPlayer(), true);
            }
        } else if (this.isGlowing) {
            this.glowHandler(this.getPetUser().getPlayer(), false);
        }
        if ((name = this.pet.getEntity().getCustomName()) == null) {
            return;
        }
        if (name.isEmpty()) {
            return;
        }
        if (name.equals(this.getEntity().getCustomName())) {
            return;
        }
        this.getEntity().setCustomName(name);
    }

    private void glowHandler(Player player, boolean glow) {
        try {
            ArmorStand entity = this.getEntity();
            if (this instanceof IEntityControllerPet) {
                entity = ((IEntityControllerPet)((Object)this)).getVisibleEntity().getEntity();
            }
            this.isGlowing = glow;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void teleportToOwner() {
        this.user.getUserLocation().ifPresent(location -> {
            this.a_(location.getX(), location.getY(), location.getZ());
            this.pet.a_(location.getX(), location.getY(), location.getZ());
            SimplePets.getPetUtilities().runPetCommands(CommandReason.TELEPORT, this.user, this.getPetType());
            SimplePets.getParticleHandler().sendParticle(ParticleHandler.Reason.TELEPORT, this.user.getPlayer(), (Location)location);
        });
    }

    @Override
    public void handleAdditionalStorage(String pluginKey, Function<StorageTagCompound, StorageTagCompound> compound) {
        this.additional.put(pluginKey, compound.apply(this.additional.getOrDefault(pluginKey, new StorageTagCompound())));
    }

    @Override
    public UUID getOwnerUUID() {
        return this.user.getOwnerUUID();
    }

    @Override
    public PetUser getPetUser() {
        return this.user;
    }

    @Override
    public PetType getPetType() {
        return PetType.ARMOR_STAND;
    }

    public ArmorStand getEntity() {
        return (ArmorStand)this.getBukkitEntity();
    }

    @Override
    public boolean attachOwner() {
        this.bR();
        Player owner = this.user.getPlayer();
        if (owner != null) {
            SimplePets.getPetUtilities().runPetCommands(CommandReason.RIDE, this.user, this.getPetType());
            return this.getBukkitEntity().addPassenger((Entity)owner);
        }
        return false;
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = this.pet.asCompound();
        object.setBoolean("small", this.isSmallStand());
        object.setBoolean("clone", this.isOwner());
        object.setBoolean("restricted", this.restricted);
        object.setEnum("glow-color", (Enum)this.getGlowColor());
        if (!this.isPetVisible()) {
            object.setBoolean("visible", !this.isPetVisible());
        }
        StorageTagCompound items = new StorageTagCompound();
        if (this.getHeadItem() != null) {
            items.setTag("head", this.parseItem(this.getHeadItem()));
        }
        if (this.getBodyItem() != null) {
            items.setTag("body", this.parseItem(this.getBodyItem()));
        }
        if (this.getLegItem() != null) {
            items.setTag("legs", this.parseItem(this.getLegItem()));
        }
        if (this.getFootItem() != null) {
            items.setTag("boots", this.parseItem(this.getFootItem()));
        }
        if (this.getLeftArmItem() != null) {
            items.setTag("left_arm", this.parseItem(this.getLeftArmItem()));
        }
        if (this.getRightArmItem() != null) {
            items.setTag("right_arm", this.parseItem(this.getRightArmItem()));
        }
        if (!items.hasNoTags()) {
            object.setTag("items", items);
        }
        if (!this.additional.isEmpty()) {
            StorageTagCompound additional = new StorageTagCompound();
            this.additional.forEach(additional::setTag);
            object.setTag("additional", additional);
        }
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("glow-color")) {
            this.setGlowColor(object.getEnum("glow-color", ChatColor.class, ChatColor.WHITE));
        }
        if (object.hasKey("restricted")) {
            this.setRestricted(object.getBoolean("restricted"));
        }
        if (object.hasKey("small")) {
            this.setSmallStand(object.getBoolean("small"));
        }
        if (object.hasKey("clone")) {
            this.setOwner(object.getBoolean("clone"));
        }
        if (object.hasKey("invisible")) {
            this.setPetVisible(!object.getBoolean("invisible"));
        }
        if (object.hasKey("visible")) {
            this.setPetVisible(object.getBoolean("visible"));
        }
        if (object.hasKey("items")) {
            StorageTagCompound items = object.getCompoundTag("items");
            if (items.hasKey("head")) {
                this.setHeadItem(this.parseString(items.getTag("head")));
            }
            if (items.hasKey("body")) {
                this.setBodyItem(this.parseString(items.getTag("body")));
            }
            if (items.hasKey("legs")) {
                this.setLegItem(this.parseString(items.getTag("legs")));
            }
            if (items.hasKey("boots")) {
                this.setFootItem(this.parseString(items.getTag("boots")));
            }
            if (items.hasKey("left_arm")) {
                this.setLeftArmItem(this.parseString(items.getTag("left_arm")));
            }
            if (items.hasKey("right_arm")) {
                this.setRightArmItem(this.parseString(items.getTag("right_arm")));
            }
        }
        if (object.hasKey("additional")) {
            StorageTagCompound additional = object.getCompoundTag("additional");
            additional.getKeySet().forEach(pluginKey -> this.additional.put((String)pluginKey, additional.getCompoundTag((String)pluginKey)));
        }
        this.pet.applyCompound(object);
    }

    @Override
    public double getPetScale() {
        return this.h(GenericAttributes.z).g();
    }

    @Override
    public void setPetScale(double scale) {
        this.h(GenericAttributes.z).a(scale);
    }

    @Override
    public boolean isFullSize() {
        return this.getPetScale() == 1.0;
    }

    @Override
    public Optional<String> getPetName() {
        return Optional.empty();
    }

    @Override
    public void setPetName(String name) {
        this.pet.setPetName(name);
    }

    @Override
    public boolean isSmallStand() {
        return super.m();
    }

    @Override
    public void setSmallStand(boolean flag) {
        super.u(flag);
    }

    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entitytrackerentry) {
        return VersionHelper.VERSION_TRANSLATOR.getAddEntityPacket((EntityLiving)this, entitytrackerentry, EntityTypes.g, VersionHelper.getPosition((net.minecraft.world.entity.Entity)this));
    }

    @Override
    public boolean isOwner() {
        return this.minime;
    }

    @Override
    public void setOwner(boolean flag) {
        this.minime = flag;
        if (flag) {
            this.cachedItems.add(this.checkItem(this.getHeadItem()));
            this.cachedItems.add(this.checkItem(this.getBodyItem()));
            this.cachedItems.add(this.checkItem(this.getLegItem()));
            this.cachedItems.add(this.checkItem(this.getFootItem()));
            this.cachedItems.add(this.checkItem(this.getRightArmItem()));
            this.cachedItems.add(this.checkItem(this.getLeftArmItem()));
            this.handleCloning();
        } else if (this.cachedItems.size() > 5) {
            this.setHeadItem(this.cachedItems.get(0));
            this.setBodyItem(this.cachedItems.get(1));
            this.setLegItem(this.cachedItems.get(2));
            this.setFootItem(this.cachedItems.get(3));
            this.setRightArmItem(this.cachedItems.get(4));
            this.setLeftArmItem(this.cachedItems.get(5));
            this.cachedItems.clear();
        }
    }

    @Override
    public void setHeadItem(ItemStack item) {
        this.setSlot(EnumItemSlot.f, item);
    }

    @Override
    public void setBodyItem(ItemStack item) {
        this.setSlot(EnumItemSlot.e, item);
    }

    @Override
    public void setLegItem(ItemStack item) {
        this.setSlot(EnumItemSlot.d, item);
    }

    @Override
    public void setFootItem(ItemStack item) {
        this.setSlot(EnumItemSlot.c, item);
    }

    @Override
    public void setLeftArmItem(ItemStack item) {
        this.setSlot(EnumItemSlot.b, item);
    }

    @Override
    public void setRightArmItem(ItemStack item) {
        this.setSlot(EnumItemSlot.a, item);
    }

    @Override
    public boolean isRestricted() {
        return this.restricted;
    }

    @Override
    public void setRestricted(boolean flag) {
        this.restricted = flag;
    }

    @Override
    public ItemStack getHeadItem() {
        return this.getItems(EnumItemSlot.f);
    }

    @Override
    public ItemStack getBodyItem() {
        return this.getItems(EnumItemSlot.e);
    }

    @Override
    public ItemStack getLegItem() {
        return this.getItems(EnumItemSlot.d);
    }

    @Override
    public ItemStack getFootItem() {
        return this.getItems(EnumItemSlot.c);
    }

    @Override
    public ItemStack getLeftArmItem() {
        return this.getItems(EnumItemSlot.b);
    }

    @Override
    public ItemStack getRightArmItem() {
        return this.getItems(EnumItemSlot.a);
    }

    public void setSpecial(boolean isSpecial) {
        this.isSpecial = isSpecial;
    }

    @Override
    public void setHeadAngle(EulerAngle angle) {
        ((ArmorStand)this.getBukkitEntity()).setHeadPose(angle);
    }

    @Override
    public void setBodyAngle(EulerAngle angle) {
        ((ArmorStand)this.getBukkitEntity()).setBodyPose(angle);
    }

    @Override
    public void setLeftArmAngle(EulerAngle angle) {
        ((ArmorStand)this.getBukkitEntity()).setLeftArmPose(angle);
    }

    @Override
    public void setRightArmAngle(EulerAngle angle) {
        ((ArmorStand)this.getBukkitEntity()).setRightArmPose(angle);
    }

    @Override
    public void setLeftLegAngle(EulerAngle angle) {
        ((ArmorStand)this.getBukkitEntity()).setLeftLegPose(angle);
    }

    @Override
    public void setRightLegAngle(EulerAngle angle) {
        ((ArmorStand)this.getBukkitEntity()).setRightLegPose(angle);
    }

    @Override
    public EulerAngle getHeadAngle() {
        return ((ArmorStand)this.getBukkitEntity()).getHeadPose();
    }

    @Override
    public EulerAngle getBodyAngle() {
        return ((ArmorStand)this.getBukkitEntity()).getBodyPose();
    }

    @Override
    public EulerAngle getLeftArmAngle() {
        return ((ArmorStand)this.getBukkitEntity()).getLeftArmPose();
    }

    @Override
    public EulerAngle getRightArmAngle() {
        return ((ArmorStand)this.getBukkitEntity()).getRightArmPose();
    }

    @Override
    public EulerAngle getLeftLegAngle() {
        return ((ArmorStand)this.getBukkitEntity()).getLeftLegPose();
    }

    @Override
    public EulerAngle getRightLegAngle() {
        return ((ArmorStand)this.getBukkitEntity()).getRightLegPose();
    }

    @Override
    public void setBasePlateVisibility(boolean flag) {
        ((ArmorStand)this.getBukkitEntity()).setBasePlate(flag);
    }

    @Override
    public boolean hasBasePlateVisibility() {
        return ((ArmorStand)this.getBukkitEntity()).hasBasePlate();
    }

    @Override
    public boolean hasArmsVisibile() {
        return ((ArmorStand)this.getBukkitEntity()).hasArms();
    }

    @Override
    public void setArmsVisibile(boolean flag) {
        ((ArmorStand)this.getBukkitEntity()).setArms(flag);
    }

    public ItemStack getItems(EnumItemSlot enumitemslot) {
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)super.a(enumitemslot));
    }

    public void setSlot(EnumItemSlot enumitemslot, ItemStack itemstack) {
        VersionHelper.setItemSlot(this, enumitemslot, CraftItemStack.asNMSCopy((ItemStack)itemstack), false);
    }

    private ItemStack checkItem(ItemStack item) {
        if (item == null) {
            return new ItemStack(Material.AIR);
        }
        if (item.getType() == Material.AIR) {
            return new ItemStack(Material.AIR);
        }
        return item;
    }

    private StorageTagCompound parseItem(ItemStack stack) {
        return VersionHelper.fromItemStack(stack);
    }

    private ItemStack parseString(StorageBase base) {
        if (base instanceof StorageTagCompound) {
            return VersionHelper.toItemStack((StorageTagCompound)base);
        }
        if (base instanceof StorageTagString) {
            String string = ((StorageTagString)base).getString();
            if (!Base64Wrapper.isEncoded(string)) {
                throw new UnsupportedOperationException(String.format("'%s' is not a valid item format", string));
            }
            YamlConfiguration config = new YamlConfiguration();
            try {
                config.loadFromString(Base64Wrapper.decodeString(string));
            }
            catch (InvalidConfigurationException e1) {
                e1.printStackTrace();
            }
            return config.getItemStack("item");
        }
        throw new InputMismatchException("ArmorStand Pet item is not in the correct format, See: https://brainsynder.gitbook.io/simplepets/faq#how-can-i-make-it-so-the-armor-stand-has-items-when-it-spawns");
    }

    private void handleCloning() {
        PlayerInventory inventory = this.getPetUser().getPlayer().getInventory();
        ItemStack head = this.checkItem(inventory.getHelmet());
        ItemStack chest = this.checkItem(inventory.getChestplate());
        ItemStack legs = this.checkItem(inventory.getLeggings());
        ItemStack boots = this.checkItem(inventory.getBoots());
        ItemStack mainHand = this.checkItem(inventory.getItemInMainHand());
        ItemStack offHand = this.checkItem(inventory.getItemInOffHand());
        if (head.getType() == Material.AIR) {
            head = this.getSkull();
        }
        if (!this.getItems(EnumItemSlot.f).isSimilar(head)) {
            this.setSlot(EnumItemSlot.f, head);
        }
        if (chest.getType() == Material.AIR) {
            chest = new ItemBuilder(Material.DIAMOND_CHESTPLATE).build();
        }
        if (!this.getItems(EnumItemSlot.e).isSimilar(chest)) {
            this.setSlot(EnumItemSlot.e, chest);
        }
        if (legs.getType() == Material.AIR) {
            legs = new ItemBuilder(Material.IRON_LEGGINGS).build();
        }
        if (!this.getItems(EnumItemSlot.d).isSimilar(legs)) {
            this.setSlot(EnumItemSlot.d, legs);
        }
        if (boots.getType() == Material.AIR) {
            boots = new ItemBuilder(Material.GOLDEN_BOOTS).build();
        }
        if (!this.getItems(EnumItemSlot.c).isSimilar(boots)) {
            this.setSlot(EnumItemSlot.c, boots);
        }
        if (mainHand.getType() != Material.AIR) {
            if (!this.getItems(EnumItemSlot.a).isSimilar(mainHand)) {
                this.setSlot(EnumItemSlot.a, mainHand);
            }
        } else {
            this.setSlot(EnumItemSlot.a, new ItemStack(Material.AIR));
        }
        if (offHand.getType() != Material.AIR) {
            if (!this.getItems(EnumItemSlot.b).isSimilar(offHand)) {
                this.setSlot(EnumItemSlot.b, offHand);
            }
        } else {
            this.setSlot(EnumItemSlot.b, new ItemStack(Material.AIR));
        }
    }

    public ItemStack getSkull() {
        GameProfile profile = new GameProfile(this.getOwnerUUID(), this.getPetUser().getOwnerName());
        ItemStack item = new ItemBuilder(Material.PLAYER_HEAD).build();
        SkullMeta meta = (SkullMeta)item.getItemMeta();
        try {
            Method profileF = meta.getClass().getDeclaredMethod("setProfile", GameProfile.class);
            profileF.setAccessible(true);
            profileF.invoke((Object)meta, profile);
            item.setItemMeta((ItemMeta)meta);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        return item;
    }

    @Override
    public boolean isBurning() {
        return this.hasVisualFire;
    }

    @Override
    public void setBurning(boolean var) {
        this.hasVisualFire = var;
    }

    protected boolean damageEntity0(DamageSource damagesource, float f) {
        return false;
    }

    protected boolean actuallyHurt(DamageSource damagesource, float f) {
        return false;
    }

    protected boolean actuallyHurt(DamageSource damageSource, float f, EntityDamageEvent event) {
        return false;
    }

    public boolean b(ValueOutput output) {
        return false;
    }

    public boolean c(ValueOutput output) {
        return false;
    }

    public void e(ValueInput input) {
    }
}

