/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_7.entity;

import java.util.Optional;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityTypes;
import simplepets.brainsynder.api.entity.misc.ITameable;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_7.entity.EntityAgeablePet;
import simplepets.brainsynder.versions.v1_21_7.utils.PetDataAccess;

public class EntityTameablePet
extends EntityAgeablePet
implements ITameable {
    private static final DataWatcherObject<Byte> TAMEABLE_FLAGS = DataWatcher.a(EntityTameablePet.class, (DataWatcherSerializer)DataWatcherRegistry.a);
    private static final DataWatcherObject<Optional<EntityReference<EntityLiving>>> OWNER_UUID = DataWatcher.a(EntityTameablePet.class, (DataWatcherSerializer)DataWatcherRegistry.r);

    public EntityTameablePet(EntityTypes<? extends EntityInsentient> entitytypes, PetType type, PetUser user) {
        super(entitytypes, type, user);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("tamed", this.isTamed());
        data.add("sitting", this.isSitting());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(TAMEABLE_FLAGS, (byte)0);
        dataAccess.define(OWNER_UUID, Optional.empty());
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        object.setBoolean("tamed", this.isTamed());
        object.setBoolean("sitting", this.isSitting());
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("tamed")) {
            this.setTamed(object.getBoolean("tamed"));
        }
        if (object.hasKey("sitting")) {
            this.setSitting(object.getBoolean("sitting"));
        }
        super.applyCompound(object);
    }

    @Override
    public boolean isTamed() {
        return ((Byte)this.ay.a(TAMEABLE_FLAGS) & 4) != 0;
    }

    @Override
    public void setTamed(boolean flag) {
        byte i = (Byte)this.ay.a(TAMEABLE_FLAGS);
        if (flag) {
            this.ay.a(TAMEABLE_FLAGS, (Object)((byte)(i | 4)));
        } else {
            this.ay.a(TAMEABLE_FLAGS, (Object)((byte)(i & 0xFFFFFFFB)));
        }
    }

    @Override
    public boolean isSitting() {
        return ((Byte)this.ay.a(TAMEABLE_FLAGS) & 1) != 0;
    }

    @Override
    public void setSitting(boolean flag) {
        byte i = (Byte)this.ay.a(TAMEABLE_FLAGS);
        if (flag) {
            this.ay.a(TAMEABLE_FLAGS, (Object)((byte)(i | 1)));
        } else {
            this.ay.a(TAMEABLE_FLAGS, (Object)((byte)(i & 0xFFFFFFFE)));
        }
    }
}

