/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_7;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.level.World;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import simplepets.brainsynder.api.ISpawnUtil;
import simplepets.brainsynder.api.SpawnResult;
import simplepets.brainsynder.api.entity.IEntityPet;
import simplepets.brainsynder.api.event.entity.PetEntitySpawnEvent;
import simplepets.brainsynder.api.pet.CommandReason;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.plugin.config.ConfigOption;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.debug.DebugBuilder;
import simplepets.brainsynder.debug.DebugLevel;
import simplepets.brainsynder.libs.bslib.ServerVersion;
import simplepets.brainsynder.libs.bslib.SupportedVersion;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.storage.RandomCollection;
import simplepets.brainsynder.libs.bslib.utils.Colorize;
import simplepets.brainsynder.versions.v1_21_7.entity.EntityPet;
import simplepets.brainsynder.versions.v1_21_7.entity.special.EntityControllerPet;
import simplepets.brainsynder.versions.v1_21_7.helper.VersionHelper;

public class SpawnerUtil
implements ISpawnUtil {
    private final Map<PetType, Class<?>> petMap = new HashMap();
    private final Map<PetType, Integer> spawnCount = new HashMap<PetType, Integer>();

    public SpawnerUtil(ClassLoader classLoader) {
        for (PetType type : PetType.values()) {
            if (type.getEntityClass() == null) continue;
            String name = type.getEntityClass().getSimpleName().replaceFirst("I", "");
            try {
                SupportedVersion version;
                Class<?> clazz = Class.forName("simplepets.brainsynder.versions." + ServerVersion.getVersion().name() + ".entity.list." + name, false, classLoader);
                if (clazz.isAnnotationPresent(SupportedVersion.class) && !ServerVersion.isEqualNew((version = clazz.getAnnotation(SupportedVersion.class)).version())) {
                    SimplePets.getDebugLogger().debug(DebugBuilder.build(this.getClass()).setLevel(DebugLevel.WARNING).setMessages("The '" + type.getName() + "' pet is not supported for your server version [will NOT affect your server]"));
                    continue;
                }
                this.petMap.put(type, clazz);
            }
            catch (Exception ignored) {
                SimplePets.getDebugLogger().debug(DebugBuilder.build(this.getClass()).setLevel(DebugLevel.WARNING).setMessages("The '" + type.getName() + " (" + name + ")' pet is not available for your server version [will NOT affect your server]"));
            }
        }
    }

    @Override
    public SpawnResult<IEntityPet> spawnEntityPet(PetType type, PetUser user) {
        if (user.getUserLocation().isPresent()) {
            return this.spawnEntityPet(type, user, this.getRandomLocation(type, user.getUserLocation().get()));
        }
        return SpawnResult.fail("missing user location, unable to spawn pet due to no location provided");
    }

    @Override
    public SpawnResult<IEntityPet> spawnEntityPet(PetType type, PetUser user, StorageTagCompound compound) {
        if (user.getUserLocation().isPresent()) {
            return this.spawnEntityPet(type, user, compound, this.getRandomLocation(type, user.getUserLocation().get()));
        }
        return SpawnResult.fail("missing user location, unable to spawn pet due to no location provided");
    }

    @Override
    public SpawnResult<IEntityPet> spawnEntityPet(PetType type, PetUser user, Location location) {
        return this.spawnEntityPet(type, user, new StorageTagCompound(), location);
    }

    @Override
    public SpawnResult<IEntityPet> spawnEntityPet(PetType type, PetUser user, StorageTagCompound compound, Location location) {
        if (ConfigOption.INSTANCE.WORLDS_ENABLED.getValue().booleanValue() && !ConfigOption.INSTANCE.WORLDS_ALLOWED_WORLDS.getValue().contains(location.getWorld().getName())) {
            return SpawnResult.fail(Colorize.translateBungeeHex(ConfigOption.INSTANCE.WORLDS_FAIL_MESSAGE.getValue()));
        }
        if (ConfigOption.INSTANCE.MISC_TOGGLES_WORLD_CONFINES_PET_LIMITS.getValue().booleanValue()) {
            int maxHeight = location.getWorld().getMaxHeight();
            int minHeight = location.getWorld().getMinHeight();
            int y = location.getBlockY();
            if (y > maxHeight || minHeight > y) {
                return SpawnResult.fail(Colorize.translateBungeeHex(ConfigOption.INSTANCE.MISC_TOGGLES_EXCEEDS_WORLD_CONFINES.getValue()));
            }
        }
        try {
            EntityPet customEntity = type == PetType.ARMOR_STAND || type == PetType.SHULKER ? new EntityControllerPet(type, user, location) : (EntityPet)this.petMap.get((Object)type).getDeclaredConstructor(PetType.class, PetUser.class).newInstance(new Object[]{type, user});
            if (compound != null && !compound.hasNoTags()) {
                try {
                    customEntity.applyCompound(compound);
                }
                catch (Exception e) {
                    return SpawnResult.fail(String.valueOf(ChatColor.RED) + "An error occurred while applying NBT data to the pet: " + e.getMessage());
                }
            }
            customEntity.l(false);
            customEntity.n(true);
            customEntity.b(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
            customEntity.gp();
            PetEntitySpawnEvent event = new PetEntitySpawnEvent(user, customEntity);
            Bukkit.getServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                SimplePets.getPetUtilities().runPetCommands(CommandReason.FAILED, user, type);
                String reason = "";
                if (event.getReason() != null) {
                    reason = event.getReason();
                }
                if (!reason.isEmpty()) {
                    return SpawnResult.fail(reason);
                }
                return SpawnResult.fail("The spawning of this pet was cancelled by another plugin.");
            }
            if (!location.getChunk().isLoaded()) {
                location.getChunk().load();
            }
            if (VersionHelper.addEntity((World)((CraftWorld)location.getWorld()).getHandle(), (net.minecraft.world.entity.Entity)customEntity, CreatureSpawnEvent.SpawnReason.CUSTOM)) {
                user.setPet(customEntity);
                if (compound.hasKey("name")) {
                    String name = compound.getString("name");
                    if (name != null) {
                        name = name.replace("~", " ");
                    }
                    customEntity.setPetName(name);
                }
                SimplePets.getPetUtilities().runPetCommands(CommandReason.SPAWN, user, type);
                int count = this.spawnCount.getOrDefault((Object)type, 0);
                this.spawnCount.put(type, count + 1);
                return SpawnResult.success(customEntity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SimplePets.getPetUtilities().runPetCommands(CommandReason.FAILED, user, type, location);
            return SpawnResult.fail("An error occurred while trying to spawn the pet: " + e.getMessage());
        }
        return SpawnResult.fail("An unknown error occurred while trying to spawn the pet.");
    }

    @Override
    public boolean isRegistered(PetType type) {
        return this.petMap.containsKey((Object)type);
    }

    @Override
    public Optional<Object> getHandle(Entity entity) {
        if (entity == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(VersionHelper.getEntityHandle(entity));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @Override
    public Map<PetType, Integer> getSpawnCount() {
        return this.spawnCount;
    }

    private Location getRandomLocation(PetType type, Location center) {
        List<Location> locationList = this.circle(center, this.modifyInt(type, 4), 3.0, false, false, true);
        return RandomCollection.fromCollection(locationList).next();
    }

    private int modifyInt(PetType type, int number) {
        return type.isLargePet() ? number + number : number;
    }

    private List<Location> circle(Location loc, double radius, double height, boolean hollow, boolean sphere, boolean checks) {
        ArrayList<Location> circleblocks = new ArrayList<Location>();
        double cx = loc.getX();
        double cy = loc.getY();
        double cz = loc.getZ();
        for (double x = cx - radius; x <= cx + radius; x += 1.0) {
            block1: for (double z = cz - radius; z <= cz + radius; z += 1.0) {
                double y = sphere ? cy - radius : cy;
                while (true) {
                    double d = sphere ? cy + radius : cy + height;
                    if (!(y < d)) continue block1;
                    double dist = (cx - x) * (cx - x) + (cz - z) * (cz - z) + (sphere ? (cy - y) * (cy - y) : 0.0);
                    if (dist < radius * radius && (!hollow || dist >= (radius - 1.0) * (radius - 1.0))) {
                        Location l = new Location(loc.getWorld(), x, y, z);
                        if (!checks || (l.getBlock().isEmpty() || l.getBlock().isPassable()) && !l.getBlock().getRelative(BlockFace.DOWN).isEmpty() && !l.getBlock().getRelative(BlockFace.DOWN).isPassable()) {
                            circleblocks.add(l);
                        }
                    }
                    y += 1.0;
                }
            }
        }
        if (circleblocks.isEmpty()) {
            return this.circle(loc, radius, height, hollow, sphere, false);
        }
        return circleblocks;
    }
}

