/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_6.pathfinder;

import java.util.EnumSet;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.pathfinder.PathEntity;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import simplepets.brainsynder.api.entity.misc.IFlyableEntity;
import simplepets.brainsynder.api.event.entity.movment.PetTeleportEvent;
import simplepets.brainsynder.api.other.ParticleHandler;
import simplepets.brainsynder.api.pet.CommandReason;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.plugin.config.ConfigOption;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.libs.bslib.math.MathUtils;
import simplepets.brainsynder.versions.v1_21_6.entity.EntityPet;
import simplepets.brainsynder.versions.v1_21_6.helper.VersionHelper;

public class PathfinderFollowPlayer
extends PathfinderGoal {
    private final EntityPet entity;
    private final NavigationAbstract navigation;
    private final float maxRange;
    private final double minRange;
    private final int teleportDistance;
    private PetUser user;
    private EntityHuman player;
    private BlockPosition targetPos;

    public PathfinderFollowPlayer(EntityPet entity) {
        this.entity = entity;
        this.maxRange = ConfigOption.INSTANCE.PATHFINDING_MAX_DISTANCE.getValue().intValue();
        this.minRange = ConfigOption.INSTANCE.PATHFINDING_MIN_DISTANCE.getValue().intValue();
        this.teleportDistance = ConfigOption.INSTANCE.PATHFINDING_TELEPORT_DISTANCE.getValue();
        this.navigation = entity.S();
        this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
        VersionHelper.setFollowAttributes(entity, this.maxRange);
    }

    public boolean b() {
        if (this.user == null) {
            this.user = this.entity.getPetUser();
            this.player = (EntityHuman)VersionHelper.getEntityHandle((Entity)this.user.getPlayer());
        }
        if (this.user == null) {
            return false;
        }
        if (this.user.getPlayer() == null) {
            return false;
        }
        if (this.entity == null) {
            return false;
        }
        if (!this.user.getPlayer().isOnline()) {
            return false;
        }
        if (this.user.getPlayer().isInsideVehicle() && !ConfigOption.INSTANCE.PATHFINDING_FOLLOW_WHEN_RIDING.getValue().booleanValue()) {
            return false;
        }
        if (!this.user.hasPets()) {
            return false;
        }
        if (!VersionHelper.getEntityLevel((net.minecraft.world.entity.Entity)this.player).getWorld().getName().equals(VersionHelper.getEntityLevel((net.minecraft.world.entity.Entity)this.entity).getWorld().getName())) {
            return false;
        }
        this.targetPos = new BlockPosition(this.randomize(this.player.dC()), this.player.dD(), this.randomize(this.player.dI()));
        return true;
    }

    public boolean c() {
        return !this.navigation.m() && this.entity.g((net.minecraft.world.entity.Entity)this.player) < (double)(this.maxRange * this.maxRange);
    }

    public void a() {
        if (this.entity.g((net.minecraft.world.entity.Entity)this.player) >= (double)this.teleportDistance) {
            if (this.entity.f((net.minecraft.world.entity.Entity)this.player) >= 80.0f) {
                this.entity.teleportToOwner();
            } else {
                this.tryTeleport();
            }
        }
    }

    public void d() {
        if (!(this.entity instanceof IFlyableEntity) && !this.entity.aK()) {
            return;
        }
        PathEntity path = this.navigation.a(this.targetPos, 1);
        this.navigation.a(path, this.entity.h(GenericAttributes.w).g());
    }

    public void e() {
        this.navigation.n();
    }

    private void tryTeleport() {
        BlockPosition blockPosition = this.player.dx();
        double distance = this.minRange;
        for (int i = 0; i < 15; ++i) {
            double x = this.getRandomInt(-distance, distance);
            double y = this.getRandomInt(-1.0, 1.0);
            double z = this.getRandomInt(-distance, distance);
            boolean flag = this.tryTeleportTo((double)blockPosition.u() + x, (double)blockPosition.v() + y, (double)blockPosition.w() + z);
            if (!flag) continue;
            return;
        }
        this.entity.teleportToOwner();
    }

    private boolean tryTeleportTo(double x, double y, double z) {
        if (Math.abs(x - this.player.dC()) < 2.0 && Math.abs(z - this.player.dI()) < 2.0) {
            return false;
        }
        PetTeleportEvent event = new PetTeleportEvent(this.entity, new Location(this.user.getPlayer().getWorld(), x, y, z));
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPosition((int)x, (int)y, (int)z))) {
            return false;
        }
        VersionHelper.moveTo((net.minecraft.world.entity.Entity)this.entity, x + 0.5, y, z + 0.5, this.entity.dP(), this.entity.dR());
        SimplePets.getPetUtilities().runPetCommands(CommandReason.TELEPORT, this.user, this.entity.getPetType());
        SimplePets.getParticleHandler().sendParticle(ParticleHandler.Reason.TELEPORT, this.user.getPlayer(), this.entity.getEntity().getLocation());
        this.navigation.n();
        return true;
    }

    private boolean canTeleportTo(BlockPosition blockposition) {
        if (!VersionHelper.isWalkable(this.entity, blockposition.k())) {
            return false;
        }
        BlockPosition position = blockposition.b((BaseBlockPosition)this.entity.dx());
        return VersionHelper.getEntityLevel((net.minecraft.world.entity.Entity)this.entity).a((net.minecraft.world.entity.Entity)this.entity, this.entity.cV().a(position));
    }

    private int randomize(double value) {
        return (int)(value + (double)MathUtils.random((int)(-this.minRange), (int)this.minRange));
    }

    private double getRandomInt(double min, double max) {
        return (double)MathUtils.random((float)(max - min)) + min;
    }
}

