/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_6.pathfinder;

import java.util.EnumSet;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.player.EntityHuman;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import simplepets.brainsynder.api.entity.misc.EntityPetType;
import simplepets.brainsynder.api.entity.misc.IFlyableEntity;
import simplepets.brainsynder.api.event.entity.movment.PetTeleportEvent;
import simplepets.brainsynder.api.other.ParticleHandler;
import simplepets.brainsynder.api.pet.CommandReason;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.plugin.config.ConfigOption;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.libs.bslib.math.MathUtils;
import simplepets.brainsynder.versions.v1_21_6.entity.EntityPet;
import simplepets.brainsynder.versions.v1_21_6.helper.VersionHelper;

public class LegacyPathfinderFollowPlayer
extends PathfinderGoal {
    private final EntityPet entity;
    private PetUser user;
    private EntityHuman player;
    private final NavigationAbstract navigation;
    private int updateCountdownTicks;
    private final float maxDistance;
    private final float minDistance;
    private final boolean first = true;
    private boolean large = true;
    private final int largeDistance;
    private final int smallDistance;
    private final int updateInterval;

    public LegacyPathfinderFollowPlayer(EntityPet entity, int minDistance, int maxDistance) {
        this.entity = entity;
        for (Class<?> interfaceClass : entity.getClass().getInterfaces()) {
            if (!interfaceClass.isAnnotationPresent(EntityPetType.class)) continue;
            PetType type = interfaceClass.getAnnotation(EntityPetType.class).petType();
            this.large = type.isLargePet();
            break;
        }
        this.navigation = entity.S();
        this.maxDistance = this.modifyInt(maxDistance);
        this.minDistance = this.modifyInt(minDistance);
        this.largeDistance = ConfigOption.INSTANCE.LEGACY_PATHFINDING_STOP_DISTANCE_LARGE.getValue();
        this.smallDistance = ConfigOption.INSTANCE.LEGACY_PATHFINDING_STOP_DISTANCE_SMALL.getValue();
        this.updateInterval = ConfigOption.INSTANCE.LEGACY_PATHFINDING_UPDATE_INTERVAL.getValue();
        this.a(EnumSet.of(PathfinderGoal.Type.a, PathfinderGoal.Type.b));
    }

    public boolean b() {
        if (this.user == null) {
            this.user = this.entity.getPetUser();
            this.player = (EntityHuman)VersionHelper.getEntityHandle((Entity)this.user.getPlayer());
        }
        if (this.user == null) {
            return false;
        }
        if (this.user.getPlayer() == null) {
            return false;
        }
        if (this.entity == null) {
            return false;
        }
        if (!this.user.getPlayer().isOnline()) {
            return false;
        }
        if (this.user.getPlayer().isInsideVehicle() && !ConfigOption.INSTANCE.PATHFINDING_FOLLOW_WHEN_RIDING.getValue().booleanValue()) {
            return false;
        }
        if (!this.user.hasPets()) {
            return false;
        }
        if (this.user.getUserLocation().isPresent()) {
            Location location = this.user.getUserLocation().get();
            if (!location.getWorld().getName().equals(this.entity.getBukkitEntity().getLocation().getWorld().getName())) {
                return false;
            }
            double distance = this.entity.g((net.minecraft.world.entity.Entity)this.player);
            if (!(distance >= (double)(this.maxDistance * this.minDistance))) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    public boolean c() {
        if (this.navigation.l()) {
            return false;
        }
        double distance = this.entity.g((net.minecraft.world.entity.Entity)this.player);
        return !(distance < (double)(this.maxDistance * this.minDistance));
    }

    public void a() {
        if (this.entity.g((net.minecraft.world.entity.Entity)this.player) >= 155.0) {
            if (this.entity.f((net.minecraft.world.entity.Entity)this.player) >= 144.0f) {
                this.entity.teleportToOwner();
            } else {
                this.tryTeleport();
            }
            return;
        }
        if (!(this.entity instanceof IFlyableEntity) && !this.entity.aK()) {
            return;
        }
        if (--this.updateCountdownTicks <= 0) {
            this.updateCountdownTicks = this.updateInterval;
            this.navigation.a(this.navigation.a((net.minecraft.world.entity.Entity)this.player, this.getStoppingDistance()), this.entity.h(GenericAttributes.w).g());
        }
    }

    public void d() {
        this.updateCountdownTicks = 0;
    }

    public void e() {
        this.navigation.n();
    }

    private int getStoppingDistance() {
        if (SimplePets.getConfiguration() == null) {
            return 0;
        }
        return this.large ? this.largeDistance : this.smallDistance;
    }

    private int modifyInt(int number) {
        return this.large ? number + number : number;
    }

    private void tryTeleport() {
        BlockPosition blockposition = this.player.dx();
        int distance = this.modifyInt(5);
        for (int i = 0; i < 15; ++i) {
            int x = this.getRandomInt(-distance, distance);
            int y = this.getRandomInt(-1, 1);
            int z = this.getRandomInt(-distance, distance);
            boolean flag = this.tryTeleportTo(blockposition.u() + x, blockposition.v() + y, blockposition.w() + z);
            if (!flag) continue;
            return;
        }
        this.entity.teleportToOwner();
    }

    private boolean tryTeleportTo(int x, int y, int z) {
        if (Math.abs((double)x - this.player.dC()) < 2.0 && Math.abs((double)z - this.player.dI()) < 2.0) {
            return false;
        }
        PetTeleportEvent event = new PetTeleportEvent(this.entity, new Location(this.user.getPlayer().getWorld(), (double)x, (double)y, (double)z));
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPosition(x, y, z))) {
            return false;
        }
        VersionHelper.moveTo((net.minecraft.world.entity.Entity)this.entity, (double)x + 0.5, y, (double)z + 0.5, this.entity.dP(), this.entity.dR());
        SimplePets.getPetUtilities().runPetCommands(CommandReason.TELEPORT, this.user, this.entity.getPetType());
        SimplePets.getParticleHandler().sendParticle(ParticleHandler.Reason.TELEPORT, this.user.getPlayer(), this.entity.getEntity().getLocation());
        this.navigation.n();
        return true;
    }

    private boolean canTeleportTo(BlockPosition blockposition) {
        if (!VersionHelper.isWalkable(this.entity, blockposition.k())) {
            return false;
        }
        BlockPosition position = blockposition.b((BaseBlockPosition)this.entity.dx());
        return VersionHelper.getEntityLevel((net.minecraft.world.entity.Entity)this.entity).a((net.minecraft.world.entity.Entity)this.entity, this.entity.cV().a(position));
    }

    private int getRandomInt(int min, int max) {
        return MathUtils.random(max - min) + min;
    }
}

