/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_6.helper;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.IPosition;
import net.minecraft.core.IRegistry;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutEntityTeleport;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.ai.attributes.AttributeMapBase;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.level.World;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftNamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.inventory.ItemStack;
import simplepets.brainsynder.api.entity.misc.IFlyableEntity;
import simplepets.brainsynder.api.plugin.utils.HelperUtilities;
import simplepets.brainsynder.libs.bslib.internal.nbtapi.nbtapi.NBTContainer;
import simplepets.brainsynder.libs.bslib.internal.nbtapi.nbtapi.NBTReflectionUtil;
import simplepets.brainsynder.libs.bslib.nbt.JsonToNBT;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.nbt.other.NBTException;
import simplepets.brainsynder.libs.bslib.reflection.FieldAccessor;
import simplepets.brainsynder.utils.VersionFields;
import simplepets.brainsynder.versions.v1_21_6.entity.EntityPet;
import simplepets.brainsynder.versions.v1_21_6.helper.DefaultVersionTranslator;
import simplepets.brainsynder.versions.v1_21_6.helper.VersionTranslator;
import simplepets.brainsynder.versions.v1_21_6.utils.InvalidInputException;

public class VersionHelper {
    public static final VersionTranslator VERSION_TRANSLATOR = HelperUtilities.getVersionedClass("NMSVersionTranslator", VersionTranslator.class, DefaultVersionTranslator.class);
    private static final FieldAccessor<AttributeMapBase> accessor = FieldAccessor.getField(EntityLiving.class, VersionFields.current().getAttributesField(), AttributeMapBase.class);

    public static BlockPosition getPosition(net.minecraft.world.entity.Entity entity) {
        return BlockPosition.a((IPosition)new Vec3D(entity.dC(), entity.dE(), entity.dI()));
    }

    public static World getEntityLevel(net.minecraft.world.entity.Entity entity) {
        return entity.ai();
    }

    public static boolean isWalkable(EntityPet entity, BlockPosition.MutableBlockPosition blockposition) {
        return PathfinderNormal.b((EntityInsentient)entity, (BlockPosition)blockposition) == PathType.c;
    }

    public static void overrideAttributeMap(EntityPet entityPet) {
        accessor.set(entityPet, new AttributeMapBase(VersionHelper.createAttributes(entityPet).a()));
    }

    private static AttributeProvider.Builder createAttributes(EntityPet entityPet) {
        AttributeProvider.Builder builder = EntityInsentient.I();
        if (entityPet instanceof IFlyableEntity) {
            builder.a(GenericAttributes.m, 1.0);
        }
        builder.a(GenericAttributes.z, 1.0);
        builder.a(GenericAttributes.C, 1.0);
        return builder.a(GenericAttributes.w, 1.0);
    }

    public static <T> T getRegistryValue(IRegistry<T> registry, NamespacedKey key) {
        return (T)registry.getValue(CraftNamespacedKey.toMinecraft((NamespacedKey)key));
    }

    public static void killEntity(net.minecraft.world.entity.Entity entity, WorldServer level) {
        entity.c(level);
    }

    public static PacketPlayOutEntityTeleport getTeleportPacket(net.minecraft.world.entity.Entity entity) {
        return new PacketPlayOutEntityTeleport(entity.ar(), PositionMoveRotation.a((net.minecraft.world.entity.Entity)entity), Relative.j, entity.bb);
    }

    public static void moveTo(net.minecraft.world.entity.Entity entityPet, double x, double y, double z, float yaw, float pitch) {
        entityPet.b(x, y, z, yaw, pitch);
    }

    public static void setFollowAttributes(EntityPet entityPet, double value) {
        entityPet.h(GenericAttributes.n).a(value);
    }

    public static void setItemSlot(EntityArmorStand stand, EnumItemSlot enumitemslot, net.minecraft.world.item.ItemStack itemstack, boolean silent) {
        stand.setItemSlot(enumitemslot, itemstack, silent);
    }

    public static boolean addEntity(World level, net.minecraft.world.entity.Entity entity, CreatureSpawnEvent.SpawnReason reason) {
        return level.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.CUSTOM);
    }

    public static <T extends net.minecraft.world.entity.Entity> T getEntityHandle(Entity entity) {
        return (T)((CraftEntity)entity).getHandle();
    }

    public static ItemStack toItemStack(StorageTagCompound compound) {
        if (!compound.hasKey("id")) {
            return new ItemStack(Material.AIR);
        }
        if (!compound.hasKey("Count")) {
            compound.setByte("Count", (byte)1);
        }
        try {
            NBTTagCompound compoundTag = MojangsonParser.a((String)compound.toString());
            net.minecraft.world.item.ItemStack nmsItem = (net.minecraft.world.item.ItemStack)NBTReflectionUtil.convertNBTCompoundtoNMSItem(new NBTContainer(compoundTag));
            return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)nmsItem);
        }
        catch (CommandSyntaxException e) {
            throw new InvalidInputException("Failed to parse Item NBT", (Exception)((Object)e));
        }
    }

    public static StorageTagCompound fromItemStack(ItemStack item) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        net.minecraft.world.item.ItemStack nmsItem = CraftItemStack.asNMSCopy((ItemStack)item);
        compoundTag = (NBTTagCompound)NBTReflectionUtil.convertNMSItemtoNBTCompound(nmsItem).getCompound();
        try {
            return JsonToNBT.getTagFromJson(compoundTag.toString());
        }
        catch (NBTException exception) {
            throw new InvalidInputException("Failed to convert item to NBT", exception);
        }
    }

    public static void setAttributes(EntityPet entityPet, double walkSpeed, double flySpeed) {
        if (walkSpeed != -1.0) {
            entityPet.h(GenericAttributes.w).a(walkSpeed);
        }
        if (flySpeed != -1.0 && entityPet instanceof IFlyableEntity && entityPet.h(GenericAttributes.m) != null) {
            entityPet.h(GenericAttributes.m).a(flySpeed);
        }
    }
}

