/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_6.entity.utils;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.npc.VillagerProfession;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.plugin.config.ConfigOption;
import simplepets.brainsynder.api.wrappers.villager.BiomeType;
import simplepets.brainsynder.api.wrappers.villager.VillagerType;
import simplepets.brainsynder.debug.DebugLevel;
import simplepets.brainsynder.libs.bslib.reflection.Reflection;

public class EntityUtils {
    private static final Map<BiomeType, ResourceKey<net.minecraft.world.entity.npc.VillagerType>> stored = new HashMap<BiomeType, ResourceKey<net.minecraft.world.entity.npc.VillagerType>>();
    private static final Map<ResourceKey<net.minecraft.world.entity.npc.VillagerType>, BiomeType> storedInverted = new HashMap<ResourceKey<net.minecraft.world.entity.npc.VillagerType>, BiomeType>();
    private static final Random RANDOM = new Random();
    private static Scoreboard scoreboard;

    public static Team fetchTeam(Player player) {
        String key = "SimplePets-" + player.getName();
        Team team = EntityUtils.getScoreboard().getTeam(key);
        if (team == null) {
            team = EntityUtils.getScoreboard().registerNewTeam(key);
            team.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.NEVER);
            team.addEntry(player.getName());
            team.setCanSeeFriendlyInvisibles(true);
        }
        return team;
    }

    public static Scoreboard getScoreboard() {
        if (scoreboard == null) {
            scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
        }
        return scoreboard;
    }

    public static Random getRandom() {
        return RANDOM;
    }

    public static ResourceKey<net.minecraft.world.entity.npc.VillagerType> getTypeFromBiome(BiomeType type) {
        if (stored.isEmpty()) {
            EntityUtils.initStores();
        }
        return stored.get((Object)type);
    }

    public static BiomeType getBiomeFromType(net.minecraft.world.entity.npc.VillagerType type) {
        if (storedInverted.isEmpty()) {
            EntityUtils.initStores();
        }
        return storedInverted.get(type);
    }

    public static net.minecraft.world.entity.npc.VillagerType findType(String ... names) {
        for (String value : names) {
            Field field = Reflection.getField(net.minecraft.world.entity.npc.VillagerType.class, value);
            if (field == null) continue;
            Object object = null;
            try {
                object = field.get(null);
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            if (object == null) continue;
            return (net.minecraft.world.entity.npc.VillagerType)object;
        }
        return null;
    }

    private static void initStores() {
        ResourceKey DESERT = net.minecraft.world.entity.npc.VillagerType.a;
        ResourceKey JUNGLE = net.minecraft.world.entity.npc.VillagerType.b;
        ResourceKey PLAINS = net.minecraft.world.entity.npc.VillagerType.c;
        ResourceKey SAVANNA = net.minecraft.world.entity.npc.VillagerType.d;
        ResourceKey SNOW = net.minecraft.world.entity.npc.VillagerType.e;
        ResourceKey SWAMP = net.minecraft.world.entity.npc.VillagerType.f;
        ResourceKey TAIGA = net.minecraft.world.entity.npc.VillagerType.g;
        if (stored.isEmpty()) {
            stored.put(BiomeType.DESERT, (ResourceKey<net.minecraft.world.entity.npc.VillagerType>)DESERT);
            stored.put(BiomeType.JUNGLE, (ResourceKey<net.minecraft.world.entity.npc.VillagerType>)JUNGLE);
            stored.put(BiomeType.PLAINS, (ResourceKey<net.minecraft.world.entity.npc.VillagerType>)PLAINS);
            stored.put(BiomeType.SAVANNA, (ResourceKey<net.minecraft.world.entity.npc.VillagerType>)SAVANNA);
            stored.put(BiomeType.SNOW, (ResourceKey<net.minecraft.world.entity.npc.VillagerType>)SNOW);
            stored.put(BiomeType.SWAMP, (ResourceKey<net.minecraft.world.entity.npc.VillagerType>)SWAMP);
            stored.put(BiomeType.TAIGA, (ResourceKey<net.minecraft.world.entity.npc.VillagerType>)TAIGA);
        }
        if (storedInverted.isEmpty()) {
            storedInverted.put((ResourceKey<net.minecraft.world.entity.npc.VillagerType>)DESERT, BiomeType.DESERT);
            storedInverted.put((ResourceKey<net.minecraft.world.entity.npc.VillagerType>)JUNGLE, BiomeType.JUNGLE);
            storedInverted.put((ResourceKey<net.minecraft.world.entity.npc.VillagerType>)PLAINS, BiomeType.PLAINS);
            storedInverted.put((ResourceKey<net.minecraft.world.entity.npc.VillagerType>)SAVANNA, BiomeType.SAVANNA);
            storedInverted.put((ResourceKey<net.minecraft.world.entity.npc.VillagerType>)SNOW, BiomeType.SNOW);
            storedInverted.put((ResourceKey<net.minecraft.world.entity.npc.VillagerType>)SWAMP, BiomeType.SWAMP);
            storedInverted.put((ResourceKey<net.minecraft.world.entity.npc.VillagerType>)TAIGA, BiomeType.TAIGA);
        }
    }

    public static ResourceKey<VillagerProfession> getProfession(VillagerType type) {
        ResourceKey profession = VillagerProfession.b;
        switch (type) {
            case ARMORER: {
                profession = VillagerProfession.c;
                break;
            }
            case BUTCHER: {
                profession = VillagerProfession.d;
                break;
            }
            case CARTOGRAPHER: {
                profession = VillagerProfession.e;
                break;
            }
            case CLERIC: {
                profession = VillagerProfession.f;
                break;
            }
            case FARMER: {
                profession = VillagerProfession.g;
                break;
            }
            case FISHERMAN: {
                profession = VillagerProfession.h;
                break;
            }
            case FLETCHER: {
                profession = VillagerProfession.i;
                break;
            }
            case LEATHERWORKER: {
                profession = VillagerProfession.j;
                break;
            }
            case LIBRARIAN: {
                profession = VillagerProfession.k;
                break;
            }
            case MASON: {
                profession = VillagerProfession.l;
                break;
            }
            case NITWIT: {
                profession = VillagerProfession.m;
                break;
            }
            case SHEPHERD: {
                profession = VillagerProfession.n;
                break;
            }
            case TOOLSMITH: {
                profession = VillagerProfession.o;
                break;
            }
            case WEAPONSMITH: {
                profession = VillagerProfession.p;
            }
        }
        return profession;
    }

    static {
        if (ConfigOption.INSTANCE.PET_TOGGLES_GLOW_VANISH.getValue().booleanValue()) {
            SimplePets.getDebugLogger().debug(DebugLevel.WARNING, "GlowingEntities class is currently unavailable in this version...");
        }
    }
}

