/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_6.entity.list;

import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.nautilus.ZombieNautilusVariant;
import net.minecraft.world.entity.animal.nautilus.ZombieNautilusVariants;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R5.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftNamespacedKey;
import simplepets.brainsynder.api.entity.passive.IEntityZombieNautilusPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.api.wrappers.ZombieNautilusPetVariant;
import simplepets.brainsynder.libs.bslib.ServerVersion;
import simplepets.brainsynder.libs.bslib.SupportedVersion;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_6.entity.branch.EntityNautilusAbstractPet;
import simplepets.brainsynder.versions.v1_21_6.utils.PetDataAccess;
import simplepets.brainsynder.versions.v1_21_6.utils.VariantUtils;

@SupportedVersion(version=ServerVersion.v1_21_11)
public class EntityZombieNautilusPet
extends EntityNautilusAbstractPet
implements IEntityZombieNautilusPet {
    private static final DataWatcherObject<Holder<ZombieNautilusVariant>> VARIANT = DataWatcher.a(EntityZombieNautilusPet.class, (DataWatcherSerializer)DataWatcherRegistry.ZOMBIE_NAUTILUS_VARIANT);
    private ZombieNautilusPetVariant variant = ZombieNautilusPetVariant.TEMPERATE;

    public EntityZombieNautilusPet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.ZOMBIE_NAUTILUS, type, user);
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(VARIANT, VariantUtils.getDefaultOrAny(this.eb(), ZombieNautilusVariants.TEMPERATE));
    }

    @Override
    public ZombieNautilusPetVariant getVariant() {
        return this.variant;
    }

    @Override
    public void setVariant(ZombieNautilusPetVariant variant) {
        this.variant = variant;
        IRegistry registry = CraftRegistry.getMinecraftRegistry((ResourceKey)Registries.ZOMBIE_NAUTILUS_VARIANT);
        this.ay.a(VARIANT, (Object)registry.e((Object)((ZombieNautilusVariant)registry.getValue(CraftNamespacedKey.toMinecraft((NamespacedKey)variant.getKey())))));
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("variant", this.variant.getKey().toString());
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        object.setEnum("variant", this.getVariant());
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("variant")) {
            this.setVariant(object.getEnum("variant", ZombieNautilusPetVariant.class, ZombieNautilusPetVariant.TEMPERATE));
        }
        super.applyCompound(object);
    }
}

