/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_6.entity.list;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.monster.EntityShulker;
import net.minecraft.world.level.World;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_21_R5.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R5.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Shulker;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import simplepets.brainsynder.api.entity.hostile.IEntityShulkerPet;
import simplepets.brainsynder.api.entity.misc.IEntityControllerPet;
import simplepets.brainsynder.api.other.ParticleHandler;
import simplepets.brainsynder.api.pet.CommandReason;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.api.wrappers.ColorWrapper;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_6.entity.special.EntityControllerPet;
import simplepets.brainsynder.versions.v1_21_6.entity.special.EntityGhostStand;
import simplepets.brainsynder.versions.v1_21_6.helper.VersionHelper;

public class EntityShulkerPet
extends EntityShulker
implements IEntityShulkerPet {
    private Map<String, StorageTagCompound> additional;
    private EntityControllerPet pet;
    private EntityGhostStand ghostStand;
    private boolean visible = true;
    private boolean frozen = false;
    private boolean isGlowing = false;
    private ChatColor glowColor = ChatColor.WHITE;
    private PetUser user;
    private boolean rainbow = false;
    private boolean closed = true;
    private int toggle = 0;

    public EntityShulkerPet(WorldServer world) {
        super(EntityTypes.be, (World)world);
    }

    public EntityShulkerPet(EntityControllerPet pet, EntityGhostStand ghostStand, PetUser user) {
        super(EntityTypes.be, pet.ai());
        this.pet = pet;
        this.ghostStand = ghostStand;
        pet.setBabySafe(true);
        this.user = user;
        this.additional = new HashMap<String, StorageTagCompound>();
    }

    @Override
    public void fetchPetDebugInformation(JsonObject debugInfo) {
        if (!this.isRainbow()) {
            debugInfo.add("color", this.getColorWrapper().name());
        }
        debugInfo.add("rainbow", this.isRainbow());
        debugInfo.add("closed", this.isShulkerClosed());
    }

    public EntityTypes<?> ap() {
        return EntityTypes.be;
    }

    public static EntityShulkerPet spawn(Location location, EntityControllerPet pet, EntityGhostStand ghostStand) {
        EntityShulkerPet shulker = new EntityShulkerPet(pet, ghostStand, pet.getPetUser());
        shulker.a_(location.getX(), location.getY(), location.getZ());
        shulker.n(true);
        shulker.u(true);
        shulker.persist = true;
        VersionHelper.addEntity((World)((CraftWorld)location.getWorld()).getHandle(), (net.minecraft.world.entity.Entity)shulker, CreatureSpawnEvent.SpawnReason.CUSTOM);
        pet.setIgnoreVanish(true);
        return shulker;
    }

    @Override
    public void togglePetHatTask(boolean value) {
        if (!value) {
            this.ghostStand.getBukkitEntity().addPassenger((Entity)this.getBukkitEntity());
        }
    }

    public void k(Vec3D vec3d) {
        this.pet.k(vec3d);
    }

    @Override
    public EntityType getPetEntityType() {
        return EntityType.SHULKER;
    }

    @Override
    public boolean isFrozen() {
        return this.cA();
    }

    @Override
    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
        this.k(frozen ? 150 : 0);
    }

    @Override
    public boolean isPetVisible() {
        return this.visible;
    }

    @Override
    public void setPetVisible(boolean visible) {
        this.visible = visible;
        this.l(!visible);
    }

    @Override
    public void setGlowColor(ChatColor glowColor) {
        if (this.glowColor == glowColor) {
            return;
        }
        this.glowColor = glowColor;
    }

    @Override
    public ChatColor getGlowColor() {
        return this.glowColor;
    }

    @Override
    public boolean isShulkerClosed() {
        return this.closed;
    }

    @Override
    public void setShulkerClosed(boolean var) {
        this.closed = var;
        int value = 100;
        if (var) {
            value = 0;
        }
        this.b(value);
    }

    @Override
    public boolean isRainbow() {
        return this.rainbow;
    }

    @Override
    public void setRainbow(boolean rainbow) {
        this.rainbow = rainbow;
    }

    @Override
    public void setColorWrapper(ColorWrapper color) {
        this.au().a(c, (Object)(color == null || color == ColorWrapper.NONE ? (byte)16 : (byte)color.getWoolData()));
    }

    @Override
    public ColorWrapper getColorWrapper() {
        byte rawColor = (Byte)this.au().a(c);
        if (rawColor == 16) {
            return ColorWrapper.NONE;
        }
        return ColorWrapper.getByWoolData(rawColor);
    }

    public void g() {
        String name;
        super.g();
        CraftEntity bukkitEntity = this.getBukkitEntity();
        if (this.pet == null || this.pet.getBukkitEntity().isDead() || !this.pet.getBukkitEntity().isValid()) {
            VersionHelper.killEntity((net.minecraft.world.entity.Entity)this, (WorldServer)this.ai());
            return;
        }
        if (this.user == null || this.user.getPlayer() == null || !this.user.getPlayer().isOnline() || !this.user.hasPet(PetType.SHULKER)) {
            if (bukkitEntity != null) {
                bukkitEntity.remove();
            }
            return;
        }
        if (!this.closed && this.gN() < 100) {
            this.b(100);
        }
        if (this.frozen && this.cy() < 140) {
            this.k(150);
        }
        if (!this.pet.isBabySafe()) {
            this.pet.setBabySafe(true);
        }
        if (this.cs()) {
            if (!this.isGlowing) {
                this.glowHandler(this.getPetUser().getPlayer(), true);
            }
        } else if (this.isGlowing) {
            this.glowHandler(this.getPetUser().getPlayer(), false);
        }
        if (this.rainbow) {
            if (this.toggle == 4) {
                this.setColorWrapper(ColorWrapper.getNext(this.getColorWrapper()));
                this.getPetUser().updateDataMenu();
                this.toggle = 0;
            }
            ++this.toggle;
        }
        if ((name = this.pet.getEntity().getCustomName()) == null) {
            return;
        }
        if (name.isEmpty()) {
            return;
        }
        if (name.equals(this.getEntity().getCustomName())) {
            return;
        }
        this.getEntity().setCustomName(name);
    }

    private void glowHandler(Player player, boolean glow) {
        try {
            Shulker entity = this.getEntity();
            if (this instanceof IEntityControllerPet) {
                entity = ((IEntityControllerPet)((Object)this)).getVisibleEntity().getEntity();
            }
            this.isGlowing = glow;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void teleportToOwner() {
        this.user.getUserLocation().ifPresent(location -> {
            this.a_(location.getX(), location.getY(), location.getZ());
            this.pet.a_(location.getX(), location.getY(), location.getZ());
            SimplePets.getPetUtilities().runPetCommands(CommandReason.TELEPORT, this.user, this.getPetType());
            SimplePets.getParticleHandler().sendParticle(ParticleHandler.Reason.TELEPORT, this.user.getPlayer(), (Location)location);
        });
    }

    @Override
    public void handleAdditionalStorage(String pluginKey, Function<StorageTagCompound, StorageTagCompound> compound) {
        this.additional.put(pluginKey, compound.apply(this.additional.getOrDefault(pluginKey, new StorageTagCompound())));
    }

    @Override
    public UUID getOwnerUUID() {
        return this.user.getOwnerUUID();
    }

    @Override
    public PetUser getPetUser() {
        return this.user;
    }

    @Override
    public PetType getPetType() {
        return PetType.SHULKER;
    }

    public Shulker getEntity() {
        return (Shulker)this.getBukkitEntity();
    }

    @Override
    public boolean attachOwner() {
        this.bR();
        Player owner = this.user.getPlayer();
        if (owner != null) {
            SimplePets.getPetUtilities().runPetCommands(CommandReason.RIDE, this.user, this.getPetType());
            return this.getBukkitEntity().addPassenger((Entity)owner);
        }
        return false;
    }

    @Override
    public List<Entity> getEntities() {
        return IEntityShulkerPet.super.getEntities();
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = this.pet.asCompound();
        object.setEnum("glow-color", (Enum)this.getGlowColor());
        if (!this.isPetVisible()) {
            object.setBoolean("visible", !this.isPetVisible());
        }
        if (!this.additional.isEmpty()) {
            StorageTagCompound additional = new StorageTagCompound();
            this.additional.forEach(additional::setTag);
            object.setTag("additional", additional);
        }
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("glow-color")) {
            this.setGlowColor(object.getEnum("glow-color", ChatColor.class, ChatColor.WHITE));
        }
        if (object.hasKey("invisible")) {
            this.setPetVisible(!object.getBoolean("invisible"));
        }
        if (object.hasKey("visible")) {
            this.setPetVisible(object.getBoolean("visible"));
        }
        if (object.hasKey("additional")) {
            StorageTagCompound additional = object.getCompoundTag("additional");
            additional.getKeySet().forEach(pluginKey -> this.additional.put((String)pluginKey, additional.getCompoundTag((String)pluginKey)));
        }
        this.pet.applyCompound(object);
    }

    @Override
    public double getPetScale() {
        return this.h(GenericAttributes.z).g();
    }

    @Override
    public void setPetScale(double scale) {
        this.h(GenericAttributes.z).a(scale);
    }

    @Override
    public boolean isFullSize() {
        return this.getPetScale() == 1.0;
    }

    @Override
    public boolean isBig() {
        return IEntityShulkerPet.super.isBig();
    }

    @Override
    public boolean isPetSilent() {
        return IEntityShulkerPet.super.isPetSilent();
    }

    @Override
    public void setPetSilent(boolean silent) {
        IEntityShulkerPet.super.setPetSilent(silent);
    }

    @Override
    public Optional<String> getPetName() {
        return Optional.empty();
    }

    @Override
    public void setPetName(String name) {
        this.pet.setPetName(name);
    }

    public Packet<PacketListenerPlayOut> a(EntityTrackerEntry entitytrackerentry) {
        return VersionHelper.VERSION_TRANSLATOR.getAddEntityPacket((EntityLiving)this, entitytrackerentry, EntityTypes.be, VersionHelper.getPosition((net.minecraft.world.entity.Entity)this));
    }

    @Override
    public boolean isBurning() {
        return this.hasVisualFire;
    }

    @Override
    public void setBurning(boolean var) {
        this.hasVisualFire = var;
    }

    public boolean b(ValueOutput output) {
        return false;
    }

    public boolean c(ValueOutput output) {
        return false;
    }

    public void e(ValueInput input) {
    }

    protected boolean damageEntity0(DamageSource damagesource, float f) {
        return false;
    }

    protected boolean actuallyHurt(DamageSource damagesource, float f) {
        return false;
    }

    protected boolean actuallyHurt(DamageSource damageSource, float f, EntityDamageEvent event) {
        return false;
    }
}

