/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_6.entity.list;

import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import simplepets.brainsynder.api.entity.hostile.IEntityRavagerPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_6.entity.branch.EntityRaiderPet;

public class EntityRavagerPet
extends EntityRaiderPet
implements IEntityRavagerPet {
    private int attackTick = 10;
    private boolean chomping = false;

    public EntityRavagerPet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.bb, type, user);
        this.doIndirectAttach = true;
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("chomping", this.isChomping());
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        object.setBoolean("chomping", this.chomping);
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("chomping")) {
            this.setChomping(object.getBoolean("chomping", false));
        }
        super.applyCompound(object);
    }

    @Override
    public void g() {
        super.g();
        if (!this.chomping) {
            return;
        }
        if (this.attackTick > 0) {
            --this.attackTick;
        }
        if (this.attackTick <= 0) {
            this.attackTick = 20;
            this.a(SoundEffects.wq, 1.0f, 1.0f);
            this.ai().a((Entity)this, (byte)4);
        }
    }

    @Override
    public boolean isChomping() {
        return this.chomping;
    }

    @Override
    public void setChomping(boolean chomping) {
        this.chomping = chomping;
        if (chomping) {
            this.attackTick = 10;
        }
    }
}

