/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_6.entity.list;

import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import simplepets.brainsynder.api.entity.passive.IEntityGlowSquidPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_6.entity.list.EntitySquidPet;
import simplepets.brainsynder.versions.v1_21_6.utils.PetDataAccess;

public class EntityGlowSquidPet
extends EntitySquidPet
implements IEntityGlowSquidPet {
    private static final DataWatcherObject<Integer> DATA_DARK_TICKS_REMAINING = DataWatcher.a(EntityGlowSquidPet.class, (DataWatcherSerializer)DataWatcherRegistry.b);

    public EntityGlowSquidPet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.ai, type, user);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        data.add("glowing", this.isSquidGlowing());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(DATA_DARK_TICKS_REMAINING, 0);
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound compound = super.asCompound();
        compound.setBoolean("glowing", this.isSquidGlowing());
        return compound;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("glowing")) {
            this.setSquidGlowing(object.getBoolean("glowing"));
        }
        super.applyCompound(object);
    }

    @Override
    public boolean isSquidGlowing() {
        return (Integer)this.ay.a(DATA_DARK_TICKS_REMAINING) == 0;
    }

    @Override
    public void setSquidGlowing(boolean glowing) {
        this.ay.a(DATA_DARK_TICKS_REMAINING, (Object)(glowing ? 0 : 100));
    }
}

