/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_6.entity.list;

import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.CowVariant;
import net.minecraft.world.entity.animal.CowVariants;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R5.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftNamespacedKey;
import simplepets.brainsynder.api.entity.passive.IEntityCowPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.api.wrappers.TemperatureVariant;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_6.entity.EntityAgeablePet;
import simplepets.brainsynder.versions.v1_21_6.utils.PetDataAccess;
import simplepets.brainsynder.versions.v1_21_6.utils.VariantUtils;

public class EntityCowPet
extends EntityAgeablePet
implements IEntityCowPet {
    private static final DataWatcherObject<Holder<CowVariant>> VARIANT = DataWatcher.a(EntityCowPet.class, (DataWatcherSerializer)DataWatcherRegistry.z);
    private TemperatureVariant variant = TemperatureVariant.TEMPERATE;

    public EntityCowPet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.D, type, user);
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(VARIANT, VariantUtils.getDefaultOrAny(this.eb(), CowVariants.a));
    }

    @Override
    public void setVariant(TemperatureVariant variant) {
        this.variant = variant;
        IRegistry registry = CraftRegistry.getMinecraftRegistry((ResourceKey)Registries.aQ);
        this.ay.a(VARIANT, (Object)registry.e((Object)((CowVariant)registry.a(CraftNamespacedKey.toMinecraft((NamespacedKey)variant.getKey())))));
    }

    @Override
    public TemperatureVariant getVariant() {
        return this.variant;
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("variant", this.getVariant().name());
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound compound = super.asCompound();
        compound.setEnum("variant", this.getVariant());
        return compound;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("variant")) {
            this.setVariant(object.getEnum("variant", TemperatureVariant.class, TemperatureVariant.TEMPERATE));
        }
        super.applyCompound(object);
    }
}

