/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_6.entity.list;

import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityTypes;
import simplepets.brainsynder.api.entity.passive.IEntityCamelPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.libs.bslib.ServerVersion;
import simplepets.brainsynder.libs.bslib.SupportedVersion;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_6.entity.branch.EntityHorseAbstractPet;
import simplepets.brainsynder.versions.v1_21_6.utils.PetDataAccess;

@SupportedVersion(version=ServerVersion.v1_20)
public class EntityCamelPet
extends EntityHorseAbstractPet
implements IEntityCamelPet {
    private static final DataWatcherObject<Boolean> DASH = DataWatcher.a(EntityCamelPet.class, (DataWatcherSerializer)DataWatcherRegistry.k);
    private static final DataWatcherObject<Long> LAST_POSE_CHANGE_TICK = DataWatcher.a(EntityCamelPet.class, (DataWatcherSerializer)DataWatcherRegistry.c);

    public EntityCamelPet(PetType type, PetUser user) {
        this((EntityTypes<? extends EntityInsentient>)EntityTypes.u, type, user);
    }

    public EntityCamelPet(EntityTypes<? extends EntityInsentient> entityType, PetType type, PetUser user) {
        super(entityType, type, user);
        this.doIndirectAttach = false;
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("sitting", this.isSitting());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(DASH, false);
        dataAccess.define(LAST_POSE_CHANGE_TICK, 0L);
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        object.setBoolean("sitting", this.isSitting());
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("sitting")) {
            this.setSitting(object.getBoolean("sitting"));
        }
        super.applyCompound(object);
    }

    @Override
    public boolean isSitting() {
        return this.aw() == EntityPose.k && (Long)this.ay.a(LAST_POSE_CHANGE_TICK) < 0L;
    }

    @Override
    public void setSitting(boolean sitting) {
        if (sitting) {
            this.sitDown();
        } else {
            this.standUp();
        }
    }

    public void sitDown() {
        if (!this.isSitting()) {
            this.a(SoundEffects.dI, 1.0f, 1.0f);
            this.b(EntityPose.k);
            this.ay.a(LAST_POSE_CHANGE_TICK, (Object)(-this.ai().ae()));
        }
    }

    public void standUp() {
        if (this.isSitting()) {
            this.a(SoundEffects.dJ, 1.0f, 1.0f);
            this.b(EntityPose.a);
            this.ay.a(LAST_POSE_CHANGE_TICK, (Object)this.ai().ae());
        }
    }
}

