/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_11.entity.list;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariant;
import net.minecraft.world.entity.animal.wolf.WolfSoundVariants;
import net.minecraft.world.entity.animal.wolf.WolfVariant;
import net.minecraft.world.entity.animal.wolf.WolfVariants;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.v1_21_R7.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftNamespacedKey;
import simplepets.brainsynder.api.entity.passive.IEntityWolfPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.api.wrappers.WolfType;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.utils.DyeColorWrapper;
import simplepets.brainsynder.versions.v1_21_11.entity.EntityTameablePet;
import simplepets.brainsynder.versions.v1_21_11.utils.PetDataAccess;
import simplepets.brainsynder.versions.v1_21_11.utils.VariantUtils;

public class EntityWolfPet
extends EntityTameablePet
implements IEntityWolfPet {
    private static final DataWatcherObject<Boolean> BEGGING = DataWatcher.a(EntityWolfPet.class, (DataWatcherSerializer)DataWatcherRegistry.k);
    private static final DataWatcherObject<Integer> COLLAR_COLOR = DataWatcher.a(EntityWolfPet.class, (DataWatcherSerializer)DataWatcherRegistry.b);
    private static final DataWatcherObject<Long> ANGER_TIME = DataWatcher.a(EntityWolfPet.class, (DataWatcherSerializer)DataWatcherRegistry.c);
    private static final DataWatcherObject<Holder<WolfVariant>> DATA_VARIANT_ID = DataWatcher.a(EntityWolfPet.class, (DataWatcherSerializer)DataWatcherRegistry.z);
    private static final DataWatcherObject<Holder<WolfSoundVariant>> DATA_SOUND_VARIANT_ID = DataWatcher.a(EntityWolfPet.class, (DataWatcherSerializer)DataWatcherRegistry.A);
    private boolean angry = false;
    private boolean furWet = false;
    private int ticks = -1;
    private WolfType wolfType = WolfType.PALE;

    public EntityWolfPet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.bU, type, user);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("anger", this.isAngry());
        data.add("shaking", this.isShaking());
        data.add("head-tilted", this.isHeadTilted());
        data.add("collar-color", this.getColor().name());
        data.add("type", this.getWolfType().name());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        IRegistry registry = this.eo().f(Registries.bC);
        Optional soundReference = registry.a(WolfSoundVariants.a);
        dataAccess.define(DATA_VARIANT_ID, VariantUtils.getDefaultOrAny(this.eo(), WolfVariants.a));
        dataAccess.define(DATA_SOUND_VARIANT_ID, soundReference.or(() -> ((IRegistry)registry).a()).orElseThrow());
        dataAccess.define(BEGGING, false);
        dataAccess.define(COLLAR_COLOR, DyeColorWrapper.WHITE.getWoolData());
        dataAccess.define(ANGER_TIME, 0L);
    }

    @Override
    public void g() {
        super.g();
        if (this.furWet) {
            if (this.ticks == -1) {
                this.ao().a((Entity)this, (byte)8);
                this.ticks = 0;
            }
            ++this.ticks;
            if (this.ticks >= 27) {
                this.ticks = 0;
                this.ao().a((Entity)this, (byte)8);
            }
        }
        if (this.angry && (Long)this.az.a(ANGER_TIME) < 50L) {
            this.az.a(ANGER_TIME, (Object)500L);
        }
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound compound = super.asCompound();
        compound.setEnum("type", this.getWolfType());
        compound.setString("color", this.getColor().name().toLowerCase());
        compound.setBoolean("angry", this.isAngry());
        compound.setBoolean("tilted", this.isHeadTilted());
        compound.setBoolean("shaking", this.furWet);
        return compound;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("type")) {
            this.setWolfType(object.getEnum("type", WolfType.class));
        }
        if (object.hasKey("color")) {
            this.setColor(DyeColorWrapper.getByName(object.getString("color")));
        }
        if (object.hasKey("angry")) {
            this.setAngry(object.getBoolean("angry", false));
        }
        if (object.hasKey("tilted")) {
            this.setHeadTilted(object.getBoolean("tilted", false));
        }
        if (object.hasKey("shaking")) {
            this.setShaking(object.getBoolean("shaking", false));
        }
        super.applyCompound(object);
    }

    @Override
    public boolean isHeadTilted() {
        return (Boolean)this.az.a(BEGGING);
    }

    @Override
    public void setHeadTilted(boolean headTilted) {
        this.az.a(BEGGING, (Object)headTilted);
    }

    @Override
    public boolean isAngry() {
        return (Long)this.az.a(ANGER_TIME) > 0L;
    }

    @Override
    public void setAngry(boolean angry) {
        this.angry = angry;
        this.az.a(ANGER_TIME, (Object)(angry ? 500L : 0L));
    }

    @Override
    public WolfType getWolfType() {
        return this.wolfType;
    }

    @Override
    public void setWolfType(WolfType type) {
        this.wolfType = type;
        WolfVariant variant = (WolfVariant)CraftRegistry.getMinecraftRegistry((ResourceKey)Registries.bB).b(CraftNamespacedKey.toMinecraft((NamespacedKey)type.getKey())).orElseThrow();
        IRegistry registry = CraftRegistry.getMinecraftRegistry((ResourceKey)Registries.bB);
        this.az.a(DATA_VARIANT_ID, (Object)registry.e((Object)variant));
    }

    @Override
    public DyeColorWrapper getColor() {
        return DyeColorWrapper.getByWoolData((byte)((Integer)this.az.a(COLLAR_COLOR)).intValue());
    }

    @Override
    public void setColor(DyeColorWrapper color) {
        this.az.a(COLLAR_COLOR, (Object)color.getWoolData());
    }

    @Override
    public boolean isShaking() {
        return this.furWet;
    }

    @Override
    public void setShaking(boolean shaking) {
        this.furWet = shaking;
        if (!shaking) {
            this.ao().a((Entity)this, (byte)56);
        }
        this.ticks = -1;
    }
}

