/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_11.entity.list;

import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import simplepets.brainsynder.api.entity.passive.IEntityGoatPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_11.entity.EntityAgeablePet;
import simplepets.brainsynder.versions.v1_21_11.utils.PetDataAccess;

public class EntityGoatPet
extends EntityAgeablePet
implements IEntityGoatPet {
    private static final DataWatcherObject<Boolean> DATA_IS_SCREAMING_GOAT = DataWatcher.a(EntityGoatPet.class, (DataWatcherSerializer)DataWatcherRegistry.k);
    public static final DataWatcherObject<Boolean> DATA_HAS_LEFT_HORN = DataWatcher.a(EntityGoatPet.class, (DataWatcherSerializer)DataWatcherRegistry.k);
    public static final DataWatcherObject<Boolean> DATA_HAS_RIGHT_HORN = DataWatcher.a(EntityGoatPet.class, (DataWatcherSerializer)DataWatcherRegistry.k);

    public EntityGoatPet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.am, type, user);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("screaming", this.isScreaming());
        data.add("left-horn", this.hasLeftHorn());
        data.add("right-horn", this.hasRightHorn());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(DATA_IS_SCREAMING_GOAT, false);
        dataAccess.define(DATA_HAS_LEFT_HORN, true);
        dataAccess.define(DATA_HAS_RIGHT_HORN, true);
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound compound = super.asCompound();
        compound.setBoolean("screaming", this.isScreaming());
        compound.setBoolean("left-horn", this.hasLeftHorn());
        compound.setBoolean("right-horn", this.hasRightHorn());
        return compound;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("screaming")) {
            this.setScreaming(object.getBoolean("screaming"));
        }
        if (object.hasKey("left-horn")) {
            this.setLeftHorn(object.getBoolean("left-horn"));
        }
        if (object.hasKey("right-horn")) {
            this.setRightHorn(object.getBoolean("right-horn"));
        }
        super.applyCompound(object);
    }

    @Override
    public boolean isScreaming() {
        return (Boolean)this.az.a(DATA_IS_SCREAMING_GOAT);
    }

    @Override
    public void setScreaming(boolean screaming) {
        this.az.a(DATA_IS_SCREAMING_GOAT, (Object)screaming);
    }

    @Override
    public void setLeftHorn(boolean hasHorn) {
        this.az.a(DATA_HAS_LEFT_HORN, (Object)hasHorn);
    }

    @Override
    public boolean hasLeftHorn() {
        return (Boolean)this.az.a(DATA_HAS_LEFT_HORN);
    }

    @Override
    public void setRightHorn(boolean hasHorn) {
        this.az.a(DATA_HAS_RIGHT_HORN, (Object)hasHorn);
    }

    @Override
    public boolean hasRightHorn() {
        return (Boolean)this.az.a(DATA_HAS_RIGHT_HORN);
    }
}

