/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_11.entity.list;

import java.util.Optional;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_21_R7.block.data.CraftBlockData;
import simplepets.brainsynder.api.entity.hostile.IEntityEndermanPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.debug.DebugBuilder;
import simplepets.brainsynder.debug.DebugLevel;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_11.entity.EntityPetOverride;
import simplepets.brainsynder.versions.v1_21_11.utils.PetDataAccess;

public class EntityEndermanPet
extends EntityPetOverride
implements IEntityEndermanPet {
    private static final DataWatcherObject<Optional<IBlockData>> CARRIED_BLOCK = DataWatcher.a(EntityEndermanPet.class, (DataWatcherSerializer)DataWatcherRegistry.j);
    private static final DataWatcherObject<Boolean> SCREAMING = DataWatcher.a(EntityEndermanPet.class, (DataWatcherSerializer)DataWatcherRegistry.k);

    public EntityEndermanPet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.R, type, user);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        data.add("screaming", this.isScreaming());
        data.add("carried-block", this.getCarriedBlock().getAsString());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(CARRIED_BLOCK, Optional.empty());
        dataAccess.define(SCREAMING, false);
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        object.setBoolean("screaming", this.isScreaming());
        Optional data = (Optional)this.az.a(CARRIED_BLOCK);
        data.ifPresent(iBlockData -> object.setString("carried_block", CraftBlockData.fromData((IBlockData)iBlockData).getAsString()));
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("screaming")) {
            this.setScreaming(object.getBoolean("screaming"));
        }
        if (object.hasKey("carried_block")) {
            String raw = object.getString("carried_block", Material.STONE.createBlockData().getAsString());
            try {
                BlockData data = Bukkit.createBlockData((String)raw);
                if (data != null) {
                    if (data.getMaterial().name().contains("AIR")) {
                        this.az.a(CARRIED_BLOCK, Optional.empty());
                    } else {
                        IBlockData blockData = ((CraftBlockData)data).getState();
                        this.az.a(CARRIED_BLOCK, Optional.of(blockData));
                    }
                }
            }
            catch (Exception e) {
                SimplePets.getDebugLogger().debug(DebugBuilder.build(this.getClass()).setLevel(DebugLevel.ERROR).setMessages("An error occured when trying to set the block in the enderman pets hand.", "Result: " + raw, "Error Message: " + e.getMessage()));
            }
        }
        super.applyCompound(object);
    }

    @Override
    public boolean isScreaming() {
        return (Boolean)this.az.a(SCREAMING);
    }

    @Override
    public void setScreaming(boolean flag) {
        this.az.a(SCREAMING, (Object)flag);
    }

    @Override
    public BlockData getCarriedBlock() {
        IBlockData blockData = ((Optional)this.az.a(CARRIED_BLOCK)).orElse(null);
        return CraftBlockData.fromData((IBlockData)blockData);
    }

    @Override
    public void setCarriedBlock(BlockData blockData) {
        this.az.a(CARRIED_BLOCK, Optional.ofNullable(((CraftBlockData)blockData).getState()));
    }
}

