/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_11.entity.list;

import net.minecraft.core.Holder;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.level.gameevent.GameEvent;
import simplepets.brainsynder.api.entity.passive.IEntityArmadilloPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.api.wrappers.ArmadilloPhase;
import simplepets.brainsynder.libs.bslib.ServerVersion;
import simplepets.brainsynder.libs.bslib.SupportedVersion;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_11.entity.EntityAgeablePet;
import simplepets.brainsynder.versions.v1_21_11.utils.PetDataAccess;

@SupportedVersion(version=ServerVersion.v1_20_5)
public class EntityArmadilloPet
extends EntityAgeablePet
implements IEntityArmadilloPet {
    private static final DataWatcherObject<Armadillo.a> ARMADILLO_STATE = DataWatcher.a(EntityArmadilloPet.class, (DataWatcherSerializer)DataWatcherRegistry.F);

    public EntityArmadilloPet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.g, type, user);
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(ARMADILLO_STATE, Armadillo.a.a);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("phase", this.getPhase().name());
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        object.setEnum("phase", this.getPhase());
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("phase")) {
            this.setPhase(object.getEnum("phase", ArmadilloPhase.class));
        }
        super.applyCompound(object);
    }

    @Override
    public ArmadilloPhase getPhase() {
        return ArmadilloPhase.getByName(((Armadillo.a)this.az.a(ARMADILLO_STATE)).name());
    }

    @Override
    public void setPhase(ArmadilloPhase phase) {
        this.c((Holder)GameEvent.u);
        if (phase == ArmadilloPhase.STANDING) {
            this.b(SoundEffects.al);
        } else {
            this.b(SoundEffects.ai);
        }
        this.az.a(ARMADILLO_STATE, (Object)Armadillo.a.valueOf((String)phase.getMojangName()));
    }
}

