/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_11.entity.branch;

import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import simplepets.brainsynder.api.entity.misc.IRaider;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_11.entity.EntityPetOverride;
import simplepets.brainsynder.versions.v1_21_11.utils.PetDataAccess;

public abstract class EntityRaiderPet
extends EntityPetOverride
implements IRaider {
    private static final DataWatcherObject<Boolean> CELEBRATING = DataWatcher.a(EntityRaiderPet.class, (DataWatcherSerializer)DataWatcherRegistry.k);

    public EntityRaiderPet(EntityTypes<? extends EntityInsentient> entitytypes, PetType type, PetUser user) {
        super(entitytypes, type, user);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        data.add("celebrating", this.isCelebrating());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(CELEBRATING, false);
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        object.setBoolean("celebrating", this.isCelebrating());
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("celebrating")) {
            this.setCelebrating(object.getBoolean("celebrating"));
        }
        super.applyCompound(object);
    }

    @Override
    public boolean isCelebrating() {
        return (Boolean)this.az.a(CELEBRATING);
    }

    @Override
    public void setCelebrating(boolean celebrating) {
        this.az.a(CELEBRATING, (Object)celebrating);
    }
}

