/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_10.entity.list;

import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import simplepets.brainsynder.api.entity.hostile.IEntityWitherPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_10.entity.EntityPetOverride;
import simplepets.brainsynder.versions.v1_21_10.utils.PetDataAccess;

public class EntityWitherPet
extends EntityPetOverride
implements IEntityWitherPet {
    private static final DataWatcherObject<Integer> FIRST_HEAD_TARGET = DataWatcher.a(EntityWitherPet.class, (DataWatcherSerializer)DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> SECOND_HEAD_TARGET = DataWatcher.a(EntityWitherPet.class, (DataWatcherSerializer)DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> THIRD_HEAD_TARGET = DataWatcher.a(EntityWitherPet.class, (DataWatcherSerializer)DataWatcherRegistry.b);
    private static final DataWatcherObject<Integer> INVULNERABILITY_TIME = DataWatcher.a(EntityWitherPet.class, (DataWatcherSerializer)DataWatcherRegistry.b);

    public EntityWitherPet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.bO, type, user);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        data.add("shielded", this.isShielded());
        data.add("small", this.isSmall());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(FIRST_HEAD_TARGET, 0);
        dataAccess.define(SECOND_HEAD_TARGET, 0);
        dataAccess.define(THIRD_HEAD_TARGET, 0);
        dataAccess.define(INVULNERABILITY_TIME, 0);
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        object.setBoolean("shielded", this.isShielded());
        object.setBoolean("small", this.isSmall());
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("shielded")) {
            this.setShielded(object.getBoolean("shielded"));
        }
        if (object.hasKey("small")) {
            this.setSmall(object.getBoolean("small"));
        }
        super.applyCompound(object);
    }

    @Override
    public boolean isShielded() {
        return (Integer)this.az.a(INVULNERABILITY_TIME) == 1;
    }

    @Override
    public void setShielded(boolean flag) {
        this.az.a(INVULNERABILITY_TIME, (Object)(flag ? 1 : 0));
        this.x(flag ? 150 : 300);
        this.getPetUser().updateDataMenu();
    }

    @Override
    public boolean isSmall() {
        return (Integer)this.az.a(INVULNERABILITY_TIME) == 600;
    }

    @Override
    public void setSmall(boolean var) {
        this.az.a(INVULNERABILITY_TIME, (Object)(var ? 600 : 0));
        this.getPetUser().updateDataMenu();
    }
}

