/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_10.entity.list;

import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import simplepets.brainsynder.api.entity.hostile.IEntityVexPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.versions.v1_21_10.entity.EntityFlyablePet;
import simplepets.brainsynder.versions.v1_21_10.utils.PetDataAccess;

public class EntityVexPet
extends EntityFlyablePet
implements IEntityVexPet {
    protected static final DataWatcherObject<Byte> VEX_FLAGS = DataWatcher.a(EntityVexPet.class, (DataWatcherSerializer)DataWatcherRegistry.a);

    public EntityVexPet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.bH, type, user);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        data.add("powered", this.isPowered());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(VEX_FLAGS, (byte)0);
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        object.setBoolean("powered", this.isPowered());
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("powered")) {
            this.setPowered(object.getBoolean("powered"));
        }
        super.applyCompound(object);
    }

    @Override
    public boolean isPowered() {
        return ((Byte)this.az.a(VEX_FLAGS) & 1) != 0;
    }

    @Override
    public void setPowered(boolean value) {
        byte flag = (Byte)this.az.a(VEX_FLAGS);
        int j = value ? flag | 1 : flag & 0xFFFFFFFE;
        this.az.a(VEX_FLAGS, (Object)((byte)(j & 0xFF)));
    }
}

