/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.versions.v1_21_10.entity.list;

import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.network.syncher.DataWatcherSerializer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import simplepets.brainsynder.api.entity.passive.IEntitySheepPet;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.utils.DyeColorWrapper;
import simplepets.brainsynder.versions.v1_21_10.entity.EntityAgeablePet;
import simplepets.brainsynder.versions.v1_21_10.utils.PetDataAccess;

public class EntitySheepPet
extends EntityAgeablePet
implements IEntitySheepPet {
    private static final DataWatcherObject<Byte> DYE_COLOR = DataWatcher.a(EntitySheepPet.class, (DataWatcherSerializer)DataWatcherRegistry.a);
    private DyeColorWrapper color = DyeColorWrapper.WHITE;
    private boolean rainbow = false;
    private int toggle = 0;

    public EntitySheepPet(PetType type, PetUser user) {
        super((EntityTypes<? extends EntityInsentient>)EntityTypes.bg, type, user);
    }

    @Override
    public void fetchPetData(JsonObject data) {
        super.fetchPetData(data);
        if (!this.isRainbow()) {
            data.add("color", this.getColor().name());
        }
        data.add("sheared", this.isSheared());
        data.add("rainbow", this.isRainbow());
    }

    @Override
    public void populateDataAccess(PetDataAccess dataAccess) {
        super.populateDataAccess(dataAccess);
        dataAccess.define(DYE_COLOR, (byte)0);
    }

    @Override
    public StorageTagCompound asCompound() {
        StorageTagCompound object = super.asCompound();
        if (!this.rainbow) {
            object.setString("color", this.getColor().name());
        }
        object.setBoolean("sheared", this.isSheared());
        object.setBoolean("rainbow", this.rainbow);
        return object;
    }

    @Override
    public void applyCompound(StorageTagCompound object) {
        if (object.hasKey("rainbow")) {
            this.rainbow = object.getBoolean("rainbow", false);
        }
        if (object.hasKey("color")) {
            this.setColor(DyeColorWrapper.getByName(object.getString("color")));
        }
        if (object.hasKey("sheared")) {
            this.setSheared(object.getBoolean("sheared", false));
        }
        super.applyCompound(object);
    }

    @Override
    public DyeColorWrapper getColor() {
        return this.color;
    }

    @Override
    public void setColor(DyeColorWrapper color) {
        this.color = color;
        if (!this.isSheared()) {
            this.az.a(DYE_COLOR, (Object)((byte)color.getWoolData()));
        }
    }

    @Override
    public boolean isSheared() {
        byte data = (Byte)this.az.a(DYE_COLOR);
        return (data & 0xF0) != 0;
    }

    @Override
    public void setSheared(boolean flag) {
        byte data = (Byte)this.az.a(DYE_COLOR);
        if (flag) {
            this.az.a(DYE_COLOR, (Object)((byte)(data | 0x10)));
        } else {
            this.az.a(DYE_COLOR, (Object)((byte)(data & 0xFFFFFFEF)));
            this.setColor(this.color);
        }
    }

    @Override
    public void g() {
        super.g();
        if (this.rainbow) {
            if (this.toggle == 4) {
                this.setColor(DyeColorWrapper.getNext(this.getColor()));
                this.getPetUser().updateDataMenu();
                this.toggle = 0;
            }
            ++this.toggle;
        }
    }

    @Override
    public boolean isRainbow() {
        return this.rainbow;
    }

    @Override
    public void setRainbow(boolean rainbow) {
        this.rainbow = rainbow;
    }
}

