/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.permissions.PermissionAttachmentInfo;
import simplepets.brainsynder.api.ISpawnUtil;
import simplepets.brainsynder.api.SpawnResult;
import simplepets.brainsynder.api.entity.IEntityPet;
import simplepets.brainsynder.api.other.ParticleHandler;
import simplepets.brainsynder.api.pet.CommandReason;
import simplepets.brainsynder.api.pet.PetData;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.plugin.config.ConfigOption;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.debug.DebugBuilder;
import simplepets.brainsynder.debug.DebugLevel;
import simplepets.brainsynder.files.MessageFile;
import simplepets.brainsynder.files.options.MessageOption;
import simplepets.brainsynder.libs.bslib.ServerVersion;
import simplepets.brainsynder.libs.bslib.files.YamlFile;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.nms.Tellraw;
import simplepets.brainsynder.libs.bslib.reflection.FieldAccessor;
import simplepets.brainsynder.libs.bslib.reflection.Reflection;
import simplepets.brainsynder.utils.VersionFields;

public class Utilities {
    public static List<Material> getBlacklistedMaterials() {
        ArrayList<Material> materials = new ArrayList<Material>();
        for (Material material : Material.values()) {
            String name = material.name();
            if (name.contains("GLASS_PANE")) {
                materials.add(material);
            }
            if (name.contains("FENCE")) {
                materials.add(material);
            }
            if (name.contains("DOOR") && !name.contains("TRAP")) {
                materials.add(material);
            }
            if (name.contains("FENCE_GATE")) {
                materials.add(material);
            }
            if (!name.contains("THIN")) continue;
            materials.add(material);
        }
        return materials;
    }

    public static boolean handlePetSpawning(PetUser user, PetType type, StorageTagCompound compound, boolean checkDataPermissions) {
        Player player = user.getPlayer();
        if (type.isInDevelopment() && !ConfigOption.INSTANCE.PET_TOGGLES_DEV_MOBS.getValue().booleanValue()) {
            player.sendMessage(MessageFile.getTranslation(MessageOption.PET_IN_DEVELOPMENT).replace("{type}", type.getName()));
            return false;
        }
        if (!type.isSupported()) {
            player.sendMessage(MessageFile.getTranslation(MessageOption.PET_NOT_SUPPORTED).replace("{type}", type.getName()));
            return false;
        }
        ISpawnUtil spawner = SimplePets.getSpawnUtil();
        if (spawner == null) {
            return false;
        }
        if (!spawner.isRegistered(type)) {
            player.sendMessage(MessageFile.getTranslation(MessageOption.PET_NOT_REGISTERED).replace("{type}", type.getName()));
            return false;
        }
        if (!Utilities.hasPermission((CommandSender)player, type.getPermission()) && !user.getOwnedPets().contains((Object)type) && ConfigOption.INSTANCE.UTILIZE_PURCHASED_PETS.getValue().booleanValue()) {
            return false;
        }
        Utilities.applyPetDataDefaults(type, compound);
        SpawnResult<IEntityPet> result = spawner.spawnEntityPet(type, user, compound);
        return switch (result.state()) {
            default -> throw new MatchException(null, null);
            case SpawnResult.State.SUCCESS -> {
                player.sendMessage(MessageFile.getTranslation(MessageOption.SUMMONED_PET).replace("{type}", type.getName()));
                yield true;
            }
            case SpawnResult.State.FAILURE -> {
                SimplePets.getParticleHandler().sendParticle(ParticleHandler.Reason.FAILED, player, player.getLocation());
                Tellraw.fromLegacy(MessageFile.getTranslation(MessageOption.FAILED_SUMMON, false).replace("{type}", type.getName())).tooltip(result.failMessage()).send(player);
                yield false;
            }
            case SpawnResult.State.EMPTY -> {
                SimplePets.getParticleHandler().sendParticle(ParticleHandler.Reason.FAILED, player, player.getLocation());
                player.sendMessage(MessageFile.getTranslation(MessageOption.FAILED_SUMMON).replace("{type}", type.getName()));
                yield false;
            }
        };
    }

    public static void applyPetDataDefaults(PetType type, StorageTagCompound compound) {
        if (type == null || compound == null) {
            return;
        }
        for (PetData petData : type.getPetData()) {
            Object value;
            String key = petData.getNamespace().namespace();
            if (compound.hasKey(key) || (value = petData.getDefault(type).orElseGet(petData::getDefaultValue)) == null) continue;
            compound.set(key, value);
        }
    }

    public static void runPetCommands(CommandReason reason, PetUser owner, PetType type) {
        SimplePets.getPetUtilities().runPetCommands(reason, owner, type, null);
    }

    public static void runPetCommands(CommandReason reason, PetUser owner, PetType type, Location location) {
        SimplePets.getPetUtilities().runPetCommands(reason, owner, type, location);
    }

    public static String handleCommandPlaceholders(PetUser owner, IEntityPet entity, Location petLoc, String command) {
        return SimplePets.getPetUtilities().handlePlaceholders(owner, entity, petLoc, command);
    }

    public static void setPassenger(Player player, Entity entity, Entity passenger) {
        try {
            SimplePets.getDebugLogger().debug(DebugLevel.HIDDEN, "Set passenger: " + entity.addPassenger(passenger) + " - " + entity.getClass().getName() + ", " + passenger.getClass().getName());
        }
        catch (Exception e) {
            SimplePets.getDebugLogger().debug(DebugLevel.ERROR, "Could not run method IEntityPet#setPassenger");
            e.printStackTrace();
        }
    }

    public static boolean hasPermission(CommandSender sender, String permission) {
        return Utilities.hasPermission(sender, permission, false);
    }

    public static boolean hasPermission(CommandSender sender, String permission, boolean strict) {
        if (sender instanceof ConsoleCommandSender) {
            return true;
        }
        if (permission == null || permission.isEmpty()) {
            return true;
        }
        int value = Utilities.getPermission(sender, permission, strict);
        if (ConfigOption.INSTANCE.PERMISSIONS_IGNORE_LIST.getValue().contains(permission)) {
            return true;
        }
        return value == 1;
    }

    public static int getPermission(CommandSender sender, String permission, boolean strict) {
        if (ConfigOption.INSTANCE.PERMISSIONS_ENABLED.getValue().booleanValue()) {
            if (strict) {
                for (PermissionAttachmentInfo info : sender.getEffectivePermissions()) {
                    if (!info.getPermission().equalsIgnoreCase(permission)) continue;
                    return info.getValue() ? 1 : 0;
                }
                return -1;
            }
            return sender.hasPermission(permission) ? 1 : 0;
        }
        return 1;
    }

    public static int parseTypeSaveLimit(PetType type) {
        for (String line : ConfigOption.INSTANCE.PET_SAVES_TYPE_LIMIT.getValue()) {
            PetType target;
            String[] args;
            if (!line.contains("-") || (args = line.split("-")).length != 2 || (target = (PetType)PetType.getPetType(args[0]).orElse(null)) == null || type != target) continue;
            try {
                return Integer.parseInt(args[1].trim());
            }
            catch (NumberFormatException e) {
                SimplePets.getDebugLogger().debug(DebugLevel.ERROR, "Unable to parse pet-type-limit for '" + args[0] + "', " + args[1] + " is not a valid number.");
                return -1;
            }
        }
        return -1;
    }

    public static int getPermissionAmount(Player player, int defaultValue, String partialPermission) {
        int amount = defaultValue;
        if (!partialPermission.endsWith(".")) {
            return defaultValue;
        }
        for (PermissionAttachmentInfo permission : player.getEffectivePermissions()) {
            String strAmount;
            int permAmount;
            if (!permission.getValue() || !permission.getPermission().startsWith(partialPermission) || (permAmount = Integer.parseInt(strAmount = permission.getPermission().substring(partialPermission.lastIndexOf(".") + 1))) < amount) continue;
            amount = permAmount;
        }
        return amount;
    }

    public static void removePassenger(Entity entity, Entity passenger) {
        try {
            entity.eject();
            if (entity instanceof Player) {
                Utilities.resetRideCooldown(passenger);
            }
        }
        catch (Exception e) {
            SimplePets.getDebugLogger().debug(DebugLevel.ERROR, "Could not run method IEntityPet#removePassenger");
            e.printStackTrace();
        }
    }

    public static void resetRideCooldown(Entity entity) {
        FieldAccessor<Integer> field = FieldAccessor.getField(Reflection.getNmsClass("Entity", "world.entity"), VersionFields.fromServerVersion((ServerVersion)ServerVersion.getVersion()).getRideCooldownField(), Integer.TYPE);
        field.set(Reflection.getHandle(entity), 0);
    }

    public static boolean isSimilar(ItemStack main, ItemStack check) {
        ArrayList<Boolean> values = new ArrayList<Boolean>();
        if (main == null || check == null) {
            return false;
        }
        if (main.getType() == check.getType() && main.hasItemMeta() && check.hasItemMeta()) {
            ItemMeta mainMeta = main.getItemMeta();
            ItemMeta checkMeta = check.getItemMeta();
            if (mainMeta.hasDisplayName() && checkMeta.hasDisplayName()) {
                values.add(mainMeta.getDisplayName().equals(checkMeta.getDisplayName()));
            }
            if (mainMeta.hasLore() && checkMeta.hasLore()) {
                values.add(mainMeta.getLore().equals(checkMeta.getLore()));
            }
            if (mainMeta.hasEnchants() && checkMeta.hasEnchants()) {
                values.add(mainMeta.getEnchants().equals(checkMeta.getEnchants()));
            }
            if (!values.isEmpty()) {
                return !values.contains(false);
            }
        }
        return main.isSimilar(check);
    }

    public static void makeBackup(YamlFile yamlFile, File backup) {
        File file = yamlFile.getFile();
        try {
            if (!backup.exists()) {
                backup.createNewFile();
            }
            FileUtils.copyFile((File)file, (File)backup);
            SimplePets.getDebugLogger().debug(DebugBuilder.build(yamlFile.getClass()).setLevel(DebugLevel.NORMAL).setMessages("A new major config change was detected", "Saving the old config to 'plugins/SimplePets/" + backup.getParentFile().getName() + "/" + backup.getName() + "'"));
        }
        catch (IOException e) {
            SimplePets.getDebugLogger().debug(DebugBuilder.build(yamlFile.getClass()).setLevel(DebugLevel.ERROR).setMessages("Failed to create file backup for: " + file.getName(), "Error: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    public static String itemToString(ItemStack itemStack) {
        YamlConfiguration config = new YamlConfiguration();
        config.set("i", (Object)itemStack);
        return config.saveToString();
    }

    public static ItemStack stringToItem(String stringBlob) {
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.loadFromString(stringBlob);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return config.getItemStack("i", null);
    }
}

