/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.PrepareAnvilEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MenuType;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.view.AnvilView;
import org.bukkit.plugin.Plugin;
import simplepets.brainsynder.libs.bslib.item.ItemBuilder;

public final class AnvilGUI {
    private final Plugin plugin;
    private final Player player;
    private final String title;
    private final ItemStack[] initialContents;
    private final boolean preventClose;
    private final Set<Integer> interactableSlots;
    private final Consumer<StateSnapshot> closeListener;
    private final boolean concurrentClickHandlerExecution;
    private final ClickHandler clickHandler;
    private AnvilView view;
    private AnvilInventory inventory;
    private final ListenUp listener = new ListenUp();
    private boolean open;

    private static ItemStack copyItemNotNull(ItemStack stack) {
        return stack == null ? new ItemStack(Material.AIR) : stack.clone();
    }

    private AnvilGUI(Plugin plugin, Player player, String title, ItemStack[] initialContents, boolean preventClose, Set<Integer> interactableSlots, Consumer<StateSnapshot> closeListener, boolean concurrentClickHandlerExecution, ClickHandler clickHandler) {
        this.plugin = plugin;
        this.player = player;
        this.title = title;
        this.initialContents = initialContents;
        this.preventClose = preventClose;
        this.interactableSlots = interactableSlots;
        this.closeListener = closeListener;
        this.concurrentClickHandlerExecution = concurrentClickHandlerExecution;
        this.clickHandler = clickHandler;
    }

    private void openInventory() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this.listener, this.plugin);
        this.view = (AnvilView)MenuType.ANVIL.create((HumanEntity)this.player, this.title);
        this.inventory = this.view.getTopInventory();
        this.player.openInventory((InventoryView)this.view);
        for (int i = 0; i < this.initialContents.length; ++i) {
            this.inventory.setItem(i, this.initialContents[i]);
        }
        this.open = true;
    }

    public void closeInventory() {
        this.closeInventory0();
        this.player.closeInventory();
    }

    private void closeInventory0() {
        if (!this.open) {
            return;
        }
        this.open = false;
        StateSnapshot state = StateSnapshot.fromAnvilGUI(this);
        this.inventory.clear();
        HandlerList.unregisterAll((Listener)this.listener);
        if (this.closeListener != null) {
            this.closeListener.accept(state);
        }
    }

    public AnvilInventory getInventory() {
        return this.inventory;
    }

    public String getRenameText() {
        return Objects.requireNonNullElse(this.view.getRenameText(), "");
    }

    public static Builder builder() {
        return new Builder();
    }

    private final class ListenUp
    implements Listener {
        private boolean clickHandlerRunning = false;

        private ListenUp() {
        }

        @EventHandler
        public void onPluginDisable(PluginDisableEvent event) {
            if (event.getPlugin().equals((Object)AnvilGUI.this.plugin)) {
                AnvilGUI.this.closeInventory();
            }
        }

        @EventHandler(priority=EventPriority.HIGH)
        public void onPrepareAnvil(PrepareAnvilEvent event) {
            if (!event.getInventory().equals((Object)AnvilGUI.this.inventory)) {
                return;
            }
            AnvilGUI.this.view.setRepairCost(0);
            ItemStack result = AnvilGUI.this.initialContents[2];
            if (result != null) {
                event.setResult(result);
            }
            AnvilGUI.this.player.updateInventory();
        }

        @EventHandler
        public void onInventoryClick(InventoryClickEvent event) {
            if (!event.getInventory().equals((Object)AnvilGUI.this.inventory)) {
                return;
            }
            Player clicker = (Player)event.getWhoClicked();
            Inventory clickedInventory = event.getClickedInventory();
            if (clickedInventory != null && clickedInventory.equals((Object)clicker.getInventory()) && event.getClick().equals((Object)ClickType.DOUBLE_CLICK)) {
                event.setCancelled(true);
                return;
            }
            if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY && !event.getClickedInventory().equals((Object)AnvilGUI.this.inventory)) {
                event.setCancelled(true);
                return;
            }
            int rawSlot = event.getRawSlot();
            if (rawSlot >= 0 && rawSlot <= 2) {
                event.setCancelled(!AnvilGUI.this.interactableSlots.contains(rawSlot));
                if (this.clickHandlerRunning && !AnvilGUI.this.concurrentClickHandlerExecution) {
                    return;
                }
                CompletableFuture actionsFuture = (CompletableFuture)AnvilGUI.this.clickHandler.apply(rawSlot, StateSnapshot.fromAnvilGUI(AnvilGUI.this));
                this.clickHandlerRunning = true;
                ((CompletableFuture)actionsFuture.thenAccept(actions -> {
                    for (ResponseAction action : actions) {
                        action.accept(AnvilGUI.this, clicker);
                    }
                })).handle((results, exception) -> {
                    if (exception != null) {
                        AnvilGUI.this.plugin.getLogger().severe("An exception occurred in the AnvilGUI clickHandler");
                        exception.printStackTrace();
                    }
                    this.clickHandlerRunning = false;
                    return null;
                });
            }
        }

        @EventHandler
        public void onInventoryDrag(InventoryDragEvent event) {
            if (event.getInventory().equals((Object)AnvilGUI.this.inventory)) {
                for (int slot : Slot.values) {
                    if (!event.getRawSlots().contains(slot) || AnvilGUI.this.interactableSlots.contains(slot)) continue;
                    event.setCancelled(true);
                    return;
                }
            }
        }

        @EventHandler
        public void onInventoryClose(InventoryCloseEvent event) {
            if (AnvilGUI.this.open && event.getInventory().equals((Object)AnvilGUI.this.inventory)) {
                AnvilGUI.this.closeInventory0();
            }
        }
    }

    @FunctionalInterface
    public static interface ClickHandler
    extends BiFunction<Integer, StateSnapshot, CompletableFuture<List<ResponseAction>>> {
    }

    public record StateSnapshot(String text, ItemStack leftItem, ItemStack rightItem, ItemStack outputItem, Player player) {
        private static StateSnapshot fromAnvilGUI(AnvilGUI anvilGUI) {
            AnvilInventory inventory = anvilGUI.getInventory();
            return new StateSnapshot(anvilGUI.getRenameText(), AnvilGUI.copyItemNotNull(inventory.getItem(0)), AnvilGUI.copyItemNotNull(inventory.getItem(1)), AnvilGUI.copyItemNotNull(inventory.getItem(2)), anvilGUI.player);
        }
    }

    public static final class Builder {
        private Consumer<StateSnapshot> closeListener;
        private boolean concurrentClickHandlerExecution = false;
        private ClickHandler clickHandler;
        private boolean preventClose = false;
        private Set<Integer> interactableSlots = Collections.emptySet();
        private Plugin plugin;
        private String title = "";
        private String itemText;
        private ItemStack itemLeft;
        private ItemStack itemRight;
        private ItemStack itemOutput;

        public Builder preventClose() {
            this.preventClose = true;
            return this;
        }

        public Builder interactableSlots(int ... slots) {
            HashSet<Integer> newValue = new HashSet<Integer>();
            for (int slot : slots) {
                newValue.add(slot);
            }
            this.interactableSlots = newValue;
            return this;
        }

        public Builder onClose(Consumer<StateSnapshot> closeListener) {
            this.closeListener = Objects.requireNonNull(closeListener, "closeListener");
            return this;
        }

        public Builder onClickAsync(ClickHandler clickHandler) {
            this.clickHandler = Objects.requireNonNull(clickHandler, "clickHandler");
            return this;
        }

        public Builder allowConcurrentClickHandlerExecution() {
            this.concurrentClickHandlerExecution = true;
            return this;
        }

        public Builder onClick(BiFunction<Integer, StateSnapshot, List<ResponseAction>> clickHandler) {
            Objects.requireNonNull(clickHandler, "clickHandler");
            this.clickHandler = (slot, stateSnapshot) -> CompletableFuture.completedFuture((List)clickHandler.apply((Integer)slot, (StateSnapshot)stateSnapshot));
            return this;
        }

        public Builder plugin(Plugin plugin) {
            this.plugin = Objects.requireNonNull(plugin, "plugin");
            return this;
        }

        public Builder text(String text) {
            this.itemText = Objects.requireNonNull(text, "text");
            return this;
        }

        public Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            return this;
        }

        public Builder itemLeft(ItemStack item) {
            this.itemLeft = Objects.requireNonNull(item, "item").clone();
            return this;
        }

        public Builder itemRight(ItemStack item) {
            this.itemRight = Objects.requireNonNull(item, "item").clone();
            return this;
        }

        public Builder itemOutput(ItemStack item) {
            this.itemOutput = Objects.requireNonNull(item, "item").clone();
            return this;
        }

        public AnvilGUI open(Player player) {
            Objects.requireNonNull(this.plugin, "Plugin must be set");
            Objects.requireNonNull(this.clickHandler, "clickHandler must be set");
            Objects.requireNonNull(player, "player");
            if (this.itemText != null) {
                if (this.itemLeft == null) {
                    this.itemLeft = new ItemStack(Material.PAPER);
                }
                ItemMeta meta = this.itemLeft.getItemMeta();
                meta.setDisplayName(this.itemText);
                this.itemLeft.setItemMeta(meta);
            }
            AnvilGUI anvilGUI = new AnvilGUI(this.plugin, player, this.title, new ItemStack[]{this.itemLeft, this.itemRight, this.itemOutput}, this.preventClose, this.interactableSlots, this.closeListener, this.concurrentClickHandlerExecution, this.clickHandler);
            anvilGUI.openInventory();
            return anvilGUI;
        }
    }

    public static final class Slot {
        private static final int[] values = new int[]{0, 1, 2};
        public static final int INPUT_LEFT = 0;
        public static final int INPUT_RIGHT = 1;
        public static final int OUTPUT = 2;

        private Slot() {
        }

        public static int[] values() {
            return (int[])values.clone();
        }
    }

    @FunctionalInterface
    public static interface ResponseAction
    extends BiConsumer<AnvilGUI, Player> {
        public static ResponseAction replaceInputText(String text) {
            Objects.requireNonNull(text, "text");
            return (anvilgui, player) -> {
                ItemStack item = anvilgui.getInventory().getItem(2);
                if (item == null) {
                    item = anvilgui.getInventory().getItem(0);
                }
                if (item == null) {
                    throw new IllegalStateException("replaceInputText can only be used if slots OUTPUT or INPUT_LEFT are not empty");
                }
                ItemStack cloned = item.clone();
                ItemMeta meta = cloned.getItemMeta();
                meta.setDisplayName(text);
                cloned.setItemMeta(meta);
                anvilgui.getInventory().setItem(0, cloned);
            };
        }

        public static ResponseAction updateTitle(String title, boolean preserveRenameText) {
            Objects.requireNonNull(title, "title");
            return (anvilGUI, player) -> {
                AnvilInventory inventory;
                StateSnapshot oldState = StateSnapshot.fromAnvilGUI(anvilGUI);
                anvilGUI.inventory.clear();
                anvilGUI.view = (AnvilView)MenuType.ANVIL.create((HumanEntity)player, title);
                anvilGUI.inventory = inventory = anvilGUI.view.getTopInventory();
                if (preserveRenameText) {
                    ItemStack firstItem = oldState.leftItem();
                    ItemBuilder builder = ItemBuilder.fromItem(firstItem);
                    if (firstItem != null && firstItem.getType() != Material.AIR) {
                        builder.withName(oldState.text);
                        inventory.setItem(0, builder.build());
                    }
                } else {
                    inventory.setItem(0, oldState.leftItem());
                }
                inventory.setItem(1, oldState.rightItem());
                inventory.setItem(2, oldState.outputItem());
                player.openInventory((InventoryView)anvilGUI.view);
            };
        }

        public static ResponseAction openInventory(Inventory otherInventory) {
            Objects.requireNonNull(otherInventory, "otherInventory");
            return (anvilgui, player) -> player.openInventory(otherInventory);
        }

        public static ResponseAction close() {
            return (anvilgui, player) -> anvilgui.closeInventory();
        }

        public static ResponseAction run(Runnable runnable) {
            Objects.requireNonNull(runnable, "runnable");
            return (anvilgui, player) -> runnable.run();
        }
    }
}

