/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.debug.DebugBuilder;
import simplepets.brainsynder.debug.DebugLevel;
import simplepets.brainsynder.libs.bslib.nbt.JsonToNBT;
import simplepets.brainsynder.libs.bslib.nbt.StorageBase;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagList;
import simplepets.brainsynder.libs.bslib.nbt.other.NBTException;
import simplepets.brainsynder.libs.bslib.optional.BiOptional;
import simplepets.brainsynder.libs.bslib.utils.Base64Wrapper;
import simplepets.brainsynder.libs.bslib.utils.Triple;
import simplepets.brainsynder.sql.SQLData;

public interface SQLHandler {
    public static final String CREATE_TABLE = "CREATE TABLE IF NOT EXISTS " + SQLData.TABLE_PREFIX + "_players (`uuid` VARCHAR(265) NOT NULL,`name` VARCHAR(265) NOT NULL,`UnlockedPets` " + SQLHandler.getStupidTextThing() + " NOT NULL,`PetName` " + SQLHandler.getStupidTextThing() + " NOT NULL,`NeedsRespawn` " + SQLHandler.getStupidTextThing() + " NOT NULL,`SavedPets` " + SQLHandler.getStupidTextThing() + " NOT NULL)";

    public Connection implementConnection();

    public void initiateDatabase();

    public CompletableFuture<Boolean> sendPlayerData(UUID var1, String var2, StorageTagCompound var3);

    @Deprecated
    public boolean sendPlayerDataSync(UUID var1, String var2, StorageTagCompound var3);

    public CompletableFuture<StorageTagCompound> fetchData(UUID var1);

    public CompletableFuture<Integer> getRowCount();

    public CompletableFuture<BiOptional<Integer, Integer>> removeDuplicates();

    public CompletableFuture<BiOptional<Integer, Integer>> removeNPCs();

    public CompletableFuture<List<Triple<UUID, String, Integer>>> findDuplicates();

    public static String getStupidTextThing() {
        return SQLData.USE_SQLITE ? "TEXT" : "LONGTEXT";
    }

    default public StorageTagCompound rowToCompound(UUID uuid, ResultSet results, boolean syncLogs) throws SQLException {
        String savedPets;
        String spawnedPets;
        StorageTagCompound compound = new StorageTagCompound();
        String raw = results.getString("UnlockedPets");
        try {
            if (!raw.equals("W10=")) {
                compound.setTag("owned_pets", JsonToNBT.parse(Base64Wrapper.decodeString(raw)).toList());
            }
        }
        catch (NBTException e) {
            SimplePets.getDebugLogger().debug(DebugBuilder.build().setMessages("Failed to load 'UnlockedPets' for uuid: " + String.valueOf(uuid), "Result: " + raw).setSync(syncLogs).setLevel(DebugLevel.ERROR));
        }
        String rawName = results.getString("PetName");
        if (Base64Wrapper.isEncoded(rawName)) {
            rawName = Base64Wrapper.decodeString(rawName);
            try {
                compound.setTag("pet_names", JsonToNBT.parse(rawName).toList());
            }
            catch (NBTException nBTException) {
                // empty catch block
            }
        }
        if (Base64Wrapper.isEncoded(spawnedPets = results.getString("NeedsRespawn"))) {
            spawnedPets = Base64Wrapper.decodeString(spawnedPets);
            StorageTagList pets = new StorageTagList();
            try {
                JsonToNBT parser = JsonToNBT.parse(spawnedPets);
                if (spawnedPets.startsWith("[")) {
                    parser.toList().getList().forEach(storageBase -> {
                        StorageTagCompound tag = (StorageTagCompound)storageBase;
                        if (!tag.hasKey("type")) {
                            if (tag.hasKey("data")) {
                                tag.setString("type", tag.getCompoundTag("data").getString("PetType"));
                                pets.appendTag(tag);
                            }
                        } else {
                            pets.appendTag((StorageBase)storageBase);
                        }
                    });
                    compound.setTag("spawned_pets", pets);
                } else {
                    StorageTagCompound tag = parser.toCompound();
                    compound.setTag("spawned_pets", pets.appendTag(new StorageTagCompound().setString("type", tag.getString("PetType")).setTag("data", tag)));
                }
            }
            catch (NBTException parser) {
                // empty catch block
            }
        }
        if (Base64Wrapper.isEncoded(savedPets = results.getString("SavedPets"))) {
            savedPets = Base64Wrapper.decodeString(savedPets);
            StorageTagList pets = new StorageTagList();
            try {
                JsonToNBT parser = JsonToNBT.parse(savedPets);
                parser.toList().getList().forEach(storageBase -> {
                    StorageTagCompound tag = (StorageTagCompound)storageBase;
                    if (!tag.hasKey("type")) {
                        if (tag.hasKey("data")) {
                            tag.setString("type", tag.getCompoundTag("data").getString("PetType"));
                            pets.appendTag(tag);
                        }
                    } else {
                        pets.appendTag((StorageBase)storageBase);
                    }
                });
                compound.setTag("saved_pets", pets);
            }
            catch (NBTException nBTException) {
                // empty catch block
            }
        }
        return compound;
    }
}

