/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.menu.items;

import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import simplepets.brainsynder.api.entity.IEntityPet;
import simplepets.brainsynder.api.inventory.CustomInventory;
import simplepets.brainsynder.api.inventory.Item;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.debug.DebugLevel;
import simplepets.brainsynder.libs.bslib.json.JsonArray;
import simplepets.brainsynder.libs.bslib.json.JsonValue;

public abstract class CustomItem
extends Item {
    public static final String COMMANDS = "CommandsOnClick";
    public static final String TARGET = "target";
    protected static final String NAMESPACE = "namespace";

    public CustomItem(File file) {
        super(file);
    }

    public void runCommands(PetUser owner) {
        if (!this.hasKey(COMMANDS)) {
            return;
        }
        JsonArray array = (JsonArray)this.getValue(COMMANDS);
        String target = null;
        if (this.hasKey(TARGET)) {
            String string = this.getString(TARGET);
            switch (string.toLowerCase()) {
                case "player": {
                    target = "PLAYER";
                    break;
                }
                case "all": {
                    target = "ALL";
                    break;
                }
                default: {
                    if (PetType.getPetType(string).isPresent()) {
                        target = string;
                        break;
                    }
                    target = "PLAYER";
                    SimplePets.getDebugLogger().debug(DebugLevel.ERROR, "Custom Item '" + this.getName() + "' has an invalid 'target' please use \"target\": \"player\" or use \"all\" or the actual pet type");
                }
            }
        }
        if (target == null) {
            SimplePets.getDebugLogger().debug(DebugLevel.ERROR, "Custom Item '" + this.getName() + "' missing 'target' please add \"target\": \"player\" or use \"all\" or the actual pet type");
            return;
        }
        if (target.equals("ALL")) {
            owner.getPetEntities().forEach(entityPet -> {
                Object loc;
                if (owner.hasPets()) {
                    Location location = entityPet.getEntity().getLocation();
                    loc = location.getBlockX() + " " + location.getBlockY() + " " + location.getBlockZ();
                } else {
                    loc = "";
                }
                array.forEach(arg_0 -> CustomItem.lambda$runCommands$0((String)loc, owner, entityPet, arg_0));
            });
            return;
        }
        if (target.equals("PLAYER")) {
            Player player = owner.getPlayer();
            Location location = player.getLocation();
            String loc = location.getBlockX() + " " + location.getBlockY() + " " + location.getBlockZ();
            array.forEach(jsonValue -> Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), jsonValue.asString().replace("{location}", loc).replace("{name}", owner.getPlayer().getName())));
            return;
        }
        PetType.getPetType(target).ifPresent(type -> owner.getPetEntity((PetType)((Object)type)).ifPresent(entityPet -> {
            Location location = entityPet.getEntity().getLocation();
            String loc = location.getBlockX() + " " + location.getBlockY() + " " + location.getBlockZ();
            array.forEach(jsonValue -> Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), jsonValue.asString().replace("{location}", loc).replace("{name}", owner.getPlayer().getName()).replace("{type}", entityPet.getPetType().getName())));
        }));
    }

    @Override
    public void onClick(PetUser user, CustomInventory inventory, IEntityPet pet) {
        this.runCommands(user);
    }

    private static /* synthetic */ void lambda$runCommands$0(String loc, PetUser owner, IEntityPet entityPet, JsonValue jsonValue) {
        Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), jsonValue.asString().replace("{location}", loc).replace("{name}", owner.getPlayer().getName()).replace("{type}", entityPet.getPetType().getName()));
    }
}

