/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.menu.inventory;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import simplepets.brainsynder.api.ISpawnUtil;
import simplepets.brainsynder.api.event.inventory.PetInventoryAddPetItemEvent;
import simplepets.brainsynder.api.inventory.CustomInventory;
import simplepets.brainsynder.api.inventory.Item;
import simplepets.brainsynder.api.inventory.handler.InventoryType;
import simplepets.brainsynder.api.pet.IPetConfig;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.plugin.config.ConfigOption;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.libs.bslib.item.ItemBuilder;
import simplepets.brainsynder.libs.bslib.json.JsonArray;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.nbt.StorageBase;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagByte;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagByteArray;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagDouble;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagFloat;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagInt;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagIntArray;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagList;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagLong;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagShort;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagString;
import simplepets.brainsynder.libs.bslib.utils.Colorize;
import simplepets.brainsynder.libs.bslib.utils.ListPager;
import simplepets.brainsynder.managers.ItemManager;
import simplepets.brainsynder.menu.inventory.holders.SavesHolder;
import simplepets.brainsynder.menu.items.list.Air;
import simplepets.brainsynder.utils.Utilities;

public class SavesMenu
extends CustomInventory {
    private Map<String, ListPager<PetUser.Entry<PetType, StorageTagCompound>>> pagerMap;
    private Map<String, Map<StorageTagCompound, PetUser.Entry<PetType, ItemStack>>> itemMap;

    public SavesMenu(File file) {
        super(file);
    }

    @Override
    public void loadDefaults() {
        this.pagerMap = new HashMap<String, ListPager<PetUser.Entry<PetType, StorageTagCompound>>>();
        this.itemMap = new HashMap<String, Map<StorageTagCompound, PetUser.Entry<PetType, ItemStack>>>();
        this.defaults.add("size", 54);
        this.setDefault("title_comment", "The title of the GUI can support regular color codes '&c' and HEX color codes '&#FFFFFF'");
        this.defaults.add("title", "&#de9790[] &#b35349Pet Saves");
        HashMap<Integer, String> object = new HashMap<Integer, String>();
        Arrays.asList(11, 12, 13, 14, 15, 16, 17, 20, 21, 22, 23, 24, 25, 26, 29, 30, 31, 32, 33, 34, 35, 38, 39, 40, 41, 42, 43, 44).forEach(slot -> object.put((Integer)slot, "air"));
        object.put(28, "savepet");
        object.put(5, "name");
        object.put(46, "previouspage");
        object.put(49, "ride");
        object.put(50, "remove");
        object.put(51, "hat");
        object.put(54, "nextpage");
        Set set = object.entrySet();
        ArrayList list = new ArrayList(set);
        list.sort(Map.Entry.comparingByKey());
        JsonArray array = new JsonArray();
        for (Map.Entry entry : list) {
            JsonObject json = new JsonObject();
            json.add("slot", (Integer)entry.getKey());
            json.add("item", (String)entry.getValue());
            array.add(json);
        }
        this.setDefault("slots", array);
    }

    @Override
    public void onClick(int slot, ItemStack item, Player player) {
    }

    @Override
    public InventoryType getInventoryType() {
        return InventoryType.SAVES_GUI;
    }

    @Override
    public void open(PetUser user, int page) {
        if (!this.isEnabled()) {
            return;
        }
        Player player = Bukkit.getPlayer((UUID)user.getPlayer().getUniqueId());
        this.pageSave.put(player.getName(), page);
        Inventory inv = Bukkit.createInventory((InventoryHolder)new SavesHolder(), (int)this.getSize(), (String)Colorize.translateBungeeHex(this.getTitle()));
        int maxPets = 0;
        for (int placeHolder = inv.getSize(); placeHolder > 0; --placeHolder) {
            int slot2 = placeHolder - 1;
            if (this.getSlots().containsKey(slot2)) {
                Item item2 = this.getSlots().get(slot2);
                if (item2 instanceof Air) {
                    ++maxPets;
                    continue;
                }
                inv.setItem(placeHolder - 1, ItemManager.PLACEHOLDER.getItemBuilder().build());
                continue;
            }
            inv.setItem(placeHolder - 1, ItemManager.PLACEHOLDER.getItemBuilder().build());
        }
        ISpawnUtil spawnUtil = SimplePets.getSpawnUtil();
        ArrayList savedPets = Lists.newArrayList();
        boolean removeNoPerms = ConfigOption.INSTANCE.PERMISSIONS_PLAYER_ACCESS.getValue();
        user.getSavedPets().forEach(entry -> {
            PetType type = (PetType)((Object)((Object)entry.getKey()));
            if (type.isInDevelopment() && !ConfigOption.INSTANCE.PET_TOGGLES_DEV_MOBS.getValue().booleanValue()) {
                return;
            }
            SimplePets.getPetConfigManager().getPetConfig(type).ifPresent(config -> {
                if (!config.isEnabled()) {
                    return;
                }
                if (!type.isSupported()) {
                    return;
                }
                if (!spawnUtil.isRegistered(type)) {
                    return;
                }
                if (player instanceof Player) {
                    if (removeNoPerms && !Utilities.hasPermission((CommandSender)player, type.getPermission())) {
                        return;
                    }
                    savedPets.add(entry);
                }
            });
        });
        ListPager pages = new ListPager(maxPets, new ArrayList(savedPets));
        this.pagerMap.put(player.getName(), pages);
        this.getSlots().forEach((slot, item) -> {
            if (item.isEnabled() && item.addItemToInv(user, this)) {
                inv.setItem(slot.intValue(), item.getItemBuilder().build());
            }
        });
        Map storageMap = this.itemMap.getOrDefault(player.getName(), new HashMap());
        if (!pages.isEmpty()) {
            pages.getPage(page).forEach(entry -> {
                PetType type = (PetType)((Object)((Object)entry.getKey()));
                IPetConfig petConfig = SimplePets.getPetConfigManager().getPetConfig(type).orElse(null);
                StorageTagCompound compound = (StorageTagCompound)entry.getValue();
                if (type != null) {
                    ItemStack stack;
                    if (storageMap.containsKey(compound)) {
                        stack = (ItemStack)((PetUser.Entry)storageMap.get(compound)).getValue();
                    } else {
                        ItemBuilder builder = type.getBuilder().clone();
                        if (petConfig != null) {
                            builder = petConfig.getBuilder();
                        }
                        builder.clearLore();
                        if (compound.hasKey("name") && !compound.getString("name").equals("null")) {
                            builder.withName(compound.getString("name").replaceAll("%player%", player.getName()));
                        }
                        ItemBuilder finalBuilder = builder;
                        compound.getKeySet().forEach(key -> {
                            if (!key.equals("name")) {
                                StorageBase base = compound.getTag((String)key);
                                if (base instanceof StorageTagCompound) {
                                    finalBuilder.addLore("  \u00a7e" + key + "\u00a76:");
                                    for (String keys : ((StorageTagCompound)base).getKeySet()) {
                                        finalBuilder.addLore("  - \u00a7e" + keys + "\u00a76: \u00a77" + this.fetchValue(compound.getTag(keys)));
                                    }
                                } else {
                                    finalBuilder.addLore("  \u00a7e" + key + "\u00a76: \u00a77" + this.fetchValue(base));
                                }
                            }
                        });
                        stack = builder.replaceString("{player}", user.getPlayer().getName()).replaceString("{type}", type.getName()).build();
                        storageMap.put(compound, new PetUser.Entry<PetType, ItemStack>(type, stack));
                    }
                    PetInventoryAddPetItemEvent event = new PetInventoryAddPetItemEvent(this, user, (PetType)((Object)((Object)entry.getKey())), stack);
                    Bukkit.getPluginManager().callEvent((Event)event);
                    if (!event.isCancelled()) {
                        inv.addItem(new ItemStack[]{event.getItem()});
                    }
                }
            });
        }
        this.itemMap.put(player.getName(), storageMap);
        if (ConfigOption.INSTANCE.MISC_TOGGLES_CLEAR_ALL_PLACEHOLDERS.getValue().booleanValue()) {
            inv.remove(ItemManager.PLACEHOLDER.getItemBuilder().build());
        }
        player.openInventory(inv);
    }

    private String fetchValue(StorageBase base) {
        if (base instanceof StorageTagByte) {
            byte tagByte = ((StorageTagByte)base).getByte();
            if (tagByte == 0 || tagByte == 1) {
                return String.valueOf(tagByte == 1);
            }
            return String.valueOf(tagByte);
        }
        if (base instanceof StorageTagByteArray) {
            return Arrays.toString(((StorageTagByteArray)base).getByteArray());
        }
        if (base instanceof StorageTagDouble) {
            return String.valueOf(((StorageTagDouble)base).getDouble());
        }
        if (base instanceof StorageTagFloat) {
            return String.valueOf(((StorageTagFloat)base).getFloat());
        }
        if (base instanceof StorageTagInt) {
            return String.valueOf(((StorageTagInt)base).getInt());
        }
        if (base instanceof StorageTagIntArray) {
            return Arrays.toString(((StorageTagIntArray)base).getIntArray());
        }
        if (base instanceof StorageTagLong) {
            return String.valueOf(((StorageTagLong)base).getLong());
        }
        if (base instanceof StorageTagShort) {
            return String.valueOf(((StorageTagShort)base).getShort());
        }
        if (base instanceof StorageTagString) {
            return String.valueOf(((StorageTagString)base).getString());
        }
        if (base instanceof StorageTagList) {
            StorageTagList list = (StorageTagList)base;
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < list.tagCount(); ++i) {
                builder.append(this.fetchValue(list.get(i)));
            }
            return builder.toString();
        }
        return "";
    }

    public void resetMaps(PetUser owner) {
        Player player = Bukkit.getPlayer((UUID)owner.getPlayer().getUniqueId());
        this.itemMap.remove(player.getName());
        this.pagerMap.remove(player.getName());
    }

    public ListPager<PetUser.Entry<PetType, StorageTagCompound>> getPages(PetUser owner) {
        Player player = Bukkit.getPlayer((UUID)owner.getPlayer().getUniqueId());
        if (this.pagerMap.containsKey(player.getName())) {
            return this.pagerMap.get(player.getName());
        }
        return null;
    }

    public Map<StorageTagCompound, PetUser.Entry<PetType, ItemStack>> getItemStorage(PetUser owner) {
        Player player = Bukkit.getPlayer((UUID)owner.getPlayer().getUniqueId());
        return this.itemMap.getOrDefault(player.getName(), new HashMap());
    }

    @Override
    public void reset(PetUser user) {
        super.reset(user);
        String name = user.getOwnerName();
        this.itemMap.remove(name);
        this.pagerMap.remove(name);
    }
}

