/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.menu.inventory;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import simplepets.brainsynder.api.entity.IEntityPet;
import simplepets.brainsynder.api.event.inventory.PetTypeStorage;
import simplepets.brainsynder.api.inventory.CustomInventory;
import simplepets.brainsynder.api.inventory.Item;
import simplepets.brainsynder.api.inventory.handler.InventoryType;
import simplepets.brainsynder.api.pet.IPetConfig;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.plugin.config.ConfigOption;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.debug.DebugLevel;
import simplepets.brainsynder.libs.bslib.item.ItemBuilder;
import simplepets.brainsynder.libs.bslib.json.JsonArray;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.storage.StorageList;
import simplepets.brainsynder.libs.bslib.utils.Colorize;
import simplepets.brainsynder.libs.bslib.utils.ListPager;
import simplepets.brainsynder.managers.ItemManager;
import simplepets.brainsynder.menu.inventory.holders.SelectorHolder;
import simplepets.brainsynder.menu.items.list.Air;
import simplepets.brainsynder.utils.BiTask;
import simplepets.brainsynder.utils.Keys;

public class PetSelectorMenu
extends CustomInventory {
    private Map<String, ListPager<PetTypeStorage>> pagerMap;
    private Map<String, BiTask<PetUser, PetType>> taskMap;

    public PetSelectorMenu(File file) {
        super(file);
    }

    @Override
    public void loadDefaults() {
        this.pagerMap = new HashMap<String, ListPager<PetTypeStorage>>();
        this.taskMap = new HashMap<String, BiTask<PetUser, PetType>>();
        this.setDefault("__COMMENT__", "This is used when you are selecting a pet EG: pet renaming via the GUI item");
        this.setDefault("size", 54);
        this.setDefault("title_comment", "It is automatically fetched from the previous GUI");
        HashMap<Integer, String> object = new HashMap<Integer, String>();
        Arrays.asList(11, 12, 13, 14, 15, 16, 17, 20, 21, 22, 23, 24, 25, 26, 29, 30, 31, 32, 33, 34, 35, 38, 39, 40, 41, 42, 43, 44).forEach(slot -> object.put((Integer)slot, "air"));
        object.put(46, "previouspage");
        object.put(54, "nextpage");
        Set set = object.entrySet();
        ArrayList list = new ArrayList(set);
        list.sort(Map.Entry.comparingByKey());
        JsonArray array = new JsonArray();
        for (Map.Entry entry : list) {
            JsonObject json = new JsonObject();
            json.add("slot", (Integer)entry.getKey());
            json.add("item", (String)entry.getValue());
            array.add(json);
        }
        this.setDefault("slots", array);
    }

    @Override
    public void onClick(int slot, ItemStack item, Player player) {
    }

    @Override
    public InventoryType getInventoryType() {
        return InventoryType.TYPE_SELECTION_GUI;
    }

    public void setTask(String name, BiTask<PetUser, PetType> task) {
        this.taskMap.put(name, task);
    }

    public BiTask<PetUser, PetType> getTask(String name) {
        return this.taskMap.getOrDefault(name, null);
    }

    public void open(PetUser user, int page, String title) {
        Player player = user.getPlayer();
        this.pageSave.put(player.getName(), page);
        Inventory inv = Bukkit.createInventory((InventoryHolder)new SelectorHolder(), (int)this.getInteger("size", 54), (String)Colorize.translateBungeeHex(title));
        int maxPets = 0;
        for (int placeHolder = inv.getSize(); placeHolder > 0; --placeHolder) {
            int slot2 = placeHolder - 1;
            if (this.getSlots().containsKey(slot2)) {
                Item item2 = this.getSlots().get(slot2);
                if (item2 instanceof Air) {
                    ++maxPets;
                    continue;
                }
                inv.setItem(placeHolder - 1, ItemManager.PLACEHOLDER.getItemBuilder().build());
                continue;
            }
            inv.setItem(placeHolder - 1, ItemManager.PLACEHOLDER.getItemBuilder().build());
        }
        StorageList<PetTypeStorage> petTypes = new StorageList<PetTypeStorage>();
        for (IEntityPet entity : user.getPetEntities()) {
            IPetConfig petConfig = SimplePets.getPetConfigManager().getPetConfig(entity.getPetType()).orElse(null);
            ItemBuilder builder = entity.getPetType().getBuilder();
            if (petConfig != null) {
                builder = petConfig.getBuilder();
            }
            petTypes.add(new PetTypeStorage(entity.getPetType()).setItem(builder.clearLore().handleMeta(ItemMeta.class, itemMeta -> {
                itemMeta.getPersistentDataContainer().set(Keys.GUI_ITEM, PersistentDataType.INTEGER, (Object)1);
                itemMeta.getPersistentDataContainer().set(Keys.PET_TYPE_ITEM, PersistentDataType.STRING, (Object)entity.getPetType().getName());
                return itemMeta;
            }).build()));
        }
        if (petTypes.getSize() == 0) {
            return;
        }
        ListPager pages = new ListPager(maxPets, petTypes.toArrayList());
        this.pagerMap.put(player.getName(), pages);
        this.getSlots().forEach((slot, item) -> {
            if (item.isEnabled() && item.addItemToInv(user, this)) {
                inv.setItem(slot.intValue(), item.getItemBuilder().build());
            }
        });
        if (!pages.isEmpty()) {
            if (pages.exists(page)) {
                pages.getPage(page).forEach(petTypeStorage -> inv.addItem(new ItemStack[]{petTypeStorage.getItem()}));
            } else {
                SimplePets.getDebugLogger().debug(DebugLevel.WARNING, "Page does not exist (Page " + page + " / " + pages.totalPages() + ")");
            }
        }
        if (ConfigOption.INSTANCE.MISC_TOGGLES_CLEAR_ALL_PLACEHOLDERS.getValue().booleanValue()) {
            inv.remove(ItemManager.PLACEHOLDER.getItemBuilder().build());
        }
        player.openInventory(inv);
    }

    @Override
    public void open(PetUser user, int page) {
        this.open(user, page, "&#de9790[] &#b35349Pets");
    }

    public ListPager<PetTypeStorage> getPages(PetUser user) {
        Player player = user.getPlayer();
        if (this.pagerMap.containsKey(player.getName())) {
            return this.pagerMap.get(player.getName());
        }
        return null;
    }

    @Override
    public void reset(PetUser user) {
        super.reset(user);
        String name = user.getOwnerName();
        this.taskMap.remove(name);
        this.pagerMap.remove(name);
    }
}

