/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.managers;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import simplepets.brainsynder.PetCore;
import simplepets.brainsynder.api.inventory.CustomInventory;
import simplepets.brainsynder.api.inventory.handler.GUIHandler;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.libs.bslib.utils.TaskTimer;
import simplepets.brainsynder.menu.inventory.AddonMenu;
import simplepets.brainsynder.menu.inventory.DataMenu;
import simplepets.brainsynder.menu.inventory.PetSelectorMenu;
import simplepets.brainsynder.menu.inventory.SavesMenu;
import simplepets.brainsynder.menu.inventory.SelectionMenu;

public class InventoryManager
implements GUIHandler {
    private File registeredFolder;
    public static SelectionMenu SELECTION;
    public static DataMenu PET_DATA;
    public static SavesMenu PET_SAVES;
    public static AddonMenu ADDONS;
    public static PetSelectorMenu SELECTOR;
    private final List<CustomInventory> loaders = new ArrayList<CustomInventory>();

    public void initiate() {
        TaskTimer timer = new TaskTimer(this.getClass(), "initiate");
        timer.start();
        PetCore plugin = PetCore.getInstance();
        this.registeredFolder = new File(String.valueOf(plugin.getDataFolder()) + "/Inventories/AddonInventories/");
        if (!this.registeredFolder.exists()) {
            this.registeredFolder.mkdirs();
        }
        SimplePets.getDebugLogger().debug("Initializing Inventories...");
        if (this.loaders != null && !this.loaders.isEmpty()) {
            this.loaders.clear();
        }
        timer.label("clearing old data (if any)");
        SimplePets.getDebugLogger().debug("Loading Customizable Inventories Files...");
        this.loaders.add(new SelectionMenu(InventoryManager.getLocation(plugin, SelectionMenu.class)));
        this.loaders.add(new DataMenu(InventoryManager.getLocation(plugin, DataMenu.class)));
        this.loaders.add(new SavesMenu(InventoryManager.getLocation(plugin, SavesMenu.class)));
        this.loaders.add(new AddonMenu(InventoryManager.getLocation(plugin, AddonMenu.class)));
        this.loaders.add(new PetSelectorMenu(InventoryManager.getLocation(plugin, PetSelectorMenu.class)));
        timer.label("inventories registered");
        for (CustomInventory loader : this.loaders) {
            loader.save();
        }
        timer.label("saving files");
        SimplePets.getDebugLogger().debug("Files have been loaded.");
        SELECTION = this.getInventory(SelectionMenu.class).get();
        PET_DATA = this.getInventory(DataMenu.class).get();
        PET_SAVES = this.getInventory(SavesMenu.class).get();
        ADDONS = this.getInventory(AddonMenu.class).get();
        SELECTOR = this.getInventory(PetSelectorMenu.class).get();
        timer.stop();
    }

    public static File getLocation(PetCore core, Class<? extends CustomInventory> clazz) {
        File folder = new File(String.valueOf(core.getDataFolder()) + "/Inventories/");
        return new File(folder, clazz.getSimpleName() + ".json");
    }

    @Override
    public void register(Class<? extends CustomInventory> clazz) {
        CustomInventory inventory;
        try {
            Constructor<? extends CustomInventory> constructor = clazz.getConstructor(File.class);
            inventory = constructor.newInstance(new File(this.registeredFolder, clazz.getSimpleName() + ".json"));
        }
        catch (Exception e) {
            return;
        }
        inventory.save();
        this.loaders.add(inventory);
    }

    @Override
    public <T extends CustomInventory> Optional<T> getInventory(Class<T> clazz) {
        if (this.loaders == null) {
            this.initiate();
        }
        if (this.loaders.isEmpty()) {
            this.initiate();
        }
        for (CustomInventory loader : this.loaders) {
            if (!clazz.isAssignableFrom(loader.getClass())) continue;
            return Optional.of(loader);
        }
        return Optional.empty();
    }
}

