/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.managers;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import simplepets.brainsynder.PetCore;
import simplepets.brainsynder.addon.AddonCloudData;
import simplepets.brainsynder.addon.AddonConfig;
import simplepets.brainsynder.addon.AddonLocalData;
import simplepets.brainsynder.addon.PetModule;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.debug.DebugBuilder;
import simplepets.brainsynder.debug.DebugLevel;
import simplepets.brainsynder.libs.bslib.files.YamlFile;
import simplepets.brainsynder.libs.bslib.json.Json;
import simplepets.brainsynder.libs.bslib.json.JsonArray;
import simplepets.brainsynder.libs.bslib.json.JsonObject;
import simplepets.brainsynder.libs.bslib.utils.AdvString;
import simplepets.brainsynder.libs.bslib.web.WebConnector;

public class AddonManager {
    private final YamlFile addonFile;
    private final PetCore plugin;
    private final File folder;
    private final List<AddonCloudData> cloudAddons;
    private final List<String> registeredAddons;
    private final List<PetModule> rawAddons;
    private final List<PetModule> loadedAddons;
    private final Map<AddonLocalData, List<PetModule>> localDataMap;
    private final Map<AddonLocalData, List<PetModule>> tempMap;

    public AddonManager(PetCore plugin) {
        this.plugin = plugin;
        this.tempMap = Maps.newHashMap();
        this.localDataMap = Maps.newHashMap();
        this.cloudAddons = Lists.newArrayList();
        this.registeredAddons = Lists.newArrayList();
        this.rawAddons = Lists.newArrayList();
        this.loadedAddons = Lists.newArrayList();
        this.folder = new File(String.valueOf(plugin.getDataFolder()) + File.separator + "Addons");
        this.addonFile = new YamlFile(this, plugin.getDataFolder(), "AddonConfig.yml"){

            @Override
            public void loadDefaults() {
            }
        };
        if (!this.folder.exists()) {
            this.folder.mkdirs();
        }
        for (File file : this.folder.listFiles()) {
            this.loadAddon(file);
        }
    }

    public File getFolder() {
        return this.folder;
    }

    public void loadAddon(File file) {
        if (file.isDirectory()) {
            return;
        }
        if (!file.getName().endsWith(".jar")) {
            return;
        }
        JsonObject information = new JsonObject();
        try {
            ZipFile zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (!zipEntry.getName().equals("addon.json")) continue;
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                information = (JsonObject)Json.parse(new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (information.isEmpty()) {
            SimplePets.getDebugLogger().debug(DebugLevel.ERROR, file.getName() + " is missing the 'addon.json' file, This addon needs updating to the new required addon format.");
            return;
        }
        AddonLocalData localData = new AddonLocalData(file, information);
        if (!localData.getPluginSupport().isEmpty()) {
            boolean missingSupport = false;
            for (AddonLocalData.SupportData supportData2 : localData.getPluginSupport()) {
                Plugin plugin = Bukkit.getPluginManager().getPlugin(supportData2.name());
                if (plugin == null || !plugin.isEnabled()) {
                    missingSupport = true;
                    continue;
                }
                missingSupport = false;
                break;
            }
            if (missingSupport) {
                SimplePets.getDebugLogger().debug(DebugBuilder.build().setLevel(SimplePets.ADDON).setMessages("The " + (String)(localData.getName().endsWith("Addon") ? localData.getName() : localData.getName() + "Addon") + " could not find plugin requirements:"));
                localData.getPluginSupport().forEach(supportData -> SimplePets.getDebugLogger().debug(DebugBuilder.build().setLevel(SimplePets.ADDON).setMessages(" - " + supportData.url() + " (" + supportData.name() + ")")));
                return;
            }
        }
        if (!localData.getClassChecks().isEmpty()) {
            for (String path : localData.getClassChecks()) {
                try {
                    Class.forName(path, false, PetCore.getInstance().getClass().getClassLoader());
                }
                catch (Exception e) {
                    SimplePets.getDebugLogger().debug(DebugBuilder.build().setLevel(DebugLevel.ERROR).setMessages("Failed to locate '" + path + "' used for the " + localData.getName() + " addon."));
                    return;
                }
            }
        }
        try {
            URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{file.toURI().toURL()}, this.getClass().getClassLoader());
            try (JarFile jarFile = new JarFile(file);){
                Enumeration<JarEntry> e = jarFile.entries();
                ArrayList<PetModule> modules = new ArrayList<PetModule>();
                while (e.hasMoreElements()) {
                    JarEntry je = e.nextElement();
                    if (je.isDirectory() || !je.getName().endsWith(".class")) continue;
                    String className = je.getName().substring(0, je.getName().length() - 6);
                    Class<?> loadClass = urlClassLoader.loadClass(className = className.replace('/', '.'));
                    if (!PetModule.class.isAssignableFrom(loadClass)) continue;
                    try {
                        PetModule addon = (PetModule)loadClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        addon.setLocalData(localData);
                        this.rawAddons.add(addon);
                        modules.add(addon);
                    }
                    catch (NoSuchMethodException | InvocationTargetException e1) {
                        SimplePets.getDebugLogger().debug(DebugLevel.ERROR, "An error occurred when trying to load a module in the addon: " + localData.getName());
                    }
                }
                this.localDataMap.putIfAbsent(localData, modules);
                this.tempMap.put(localData, modules);
            }
            if (this.rawAddons.isEmpty()) {
                SimplePets.getDebugLogger().debug(DebugBuilder.build(this.getClass()).setLevel(SimplePets.ADDON).setMessages("Could not find a class that extends PetModule", "Are you sure '" + file.getName() + "' is an addon?"));
            }
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            SimplePets.getDebugLogger().debug(DebugBuilder.build(this.getClass()).setLevel(DebugLevel.ERROR).setMessages("Failed to load addon: " + file.getName(), "Error Message: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    public void cleanup() {
        for (PetModule addon : this.loadedAddons) {
            addon.cleanup();
            HandlerList.unregisterAll((Listener)addon);
        }
        this.loadedAddons.clear();
        this.rawAddons.clear();
    }

    public void initialize() {
        this.tempMap.forEach((localData, modules) -> {
            if (!this.isSupported(localData.getSupportedBuild())) {
                SimplePets.getDebugLogger().debug(DebugBuilder.build(this.getClass()).setLevel(SimplePets.ADDON).setMessages(localData.getName() + " (by " + String.valueOf(localData.getAuthors()) + ") is not supported for version " + PetCore.getInstance().getDescription().getVersion()));
                return;
            }
            SimplePets.getDebugLogger().debug(SimplePets.ADDON, "Loading modules for the " + localData.getName() + " addon");
            modules.forEach(module -> {
                try {
                    String name = module.getNamespace().namespace();
                    new AddonConfig(this, new File(String.valueOf(this.folder) + File.separator + "configs"), name + ".yml", (PetModule)module){
                        final /* synthetic */ PetModule val$module;
                        {
                            this.val$module = petModule;
                            super(arg0, arg1);
                        }

                        @Override
                        public void loadDefaults() {
                            this.val$module.loadDefaults(this);
                        }
                    };
                    module.setLoaded(true);
                    if (!this.addonFile.contains(name + ".Enabled")) {
                        this.addonFile.addComment(name + ".Enabled", "Enable/Disable the " + name + " module");
                        this.addonFile.set(name + ".Enabled", (Object)true);
                    }
                    this.loadedAddons.add((PetModule)module);
                    boolean enabled = this.addonFile.getBoolean(name + ".Enabled", true);
                    module.setAddonFolder(this.folder);
                    if (!module.shouldEnable()) {
                        return;
                    }
                    module.setEnabled(enabled);
                    if (module.isEnabled()) {
                        Bukkit.getPluginManager().registerEvents((Listener)module, (Plugin)this.plugin);
                        module.init();
                    }
                }
                catch (Exception e) {
                    SimplePets.getDebugLogger().debug(DebugBuilder.build(this.getClass()).setLevel(SimplePets.ADDON).setMessages("Failed to initialize addon module: " + module.getClass().getSimpleName()));
                    e.printStackTrace();
                }
            });
        });
        this.rawAddons.clear();
        this.tempMap.clear();
    }

    public Map<AddonLocalData, List<PetModule>> getLocalDataMap() {
        return this.localDataMap;
    }

    public List<AddonCloudData> getCloudAddons() {
        return this.cloudAddons;
    }

    public void downloadViaName(String name, String url, Runnable runnable) {
        CompletableFuture.runAsync(() -> {
            try {
                this.download(url, name, file -> new BukkitRunnable((File)file, runnable){
                    final /* synthetic */ File val$file;
                    final /* synthetic */ Runnable val$runnable;
                    {
                        this.val$file = file;
                        this.val$runnable = runnable;
                    }

                    public void run() {
                        AddonManager.this.loadAddon(this.val$file);
                        AddonManager.this.initialize();
                        this.val$runnable.run();
                    }
                }.runTask((Plugin)this.plugin));
            }
            catch (Exception e) {
                try {
                    File file2 = new File(this.folder.getAbsolutePath() + "/" + name);
                    file2.delete();
                    FileUtils.copyURLToFile((URL)new URL(url), (File)file2);
                    runnable.run();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public void downloadAddon(File original, String url, final Runnable runnable) {
        CompletableFuture.runAsync(() -> {
            try {
                this.download(url, original.getName(), file -> new BukkitRunnable((File)file, runnable){
                    final /* synthetic */ File val$file;
                    final /* synthetic */ Runnable val$runnable;
                    {
                        this.val$file = file;
                        this.val$runnable = runnable;
                    }

                    public void run() {
                        AddonManager.this.loadAddon(this.val$file);
                        AddonManager.this.initialize();
                        this.val$runnable.run();
                    }
                }.runTask((Plugin)this.plugin));
            }
            catch (Exception e) {
                try {
                    final File file2 = new File(this.folder.getAbsolutePath() + "/" + original.getName());
                    original.delete();
                    FileUtils.copyURLToFile((URL)new URL(url), (File)file2);
                    new BukkitRunnable(){

                        public void run() {
                            AddonManager.this.loadAddon(file2);
                            AddonManager.this.initialize();
                            runnable.run();
                        }
                    }.runTask((Plugin)this.plugin);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        });
    }

    public void toggleAddonModule(final PetModule module, boolean enabled) {
        if (enabled && this.isSupported(module.getLocalData().getSupportedBuild())) {
            new AddonConfig(this, new File(String.valueOf(this.folder) + File.separator + "configs"), module.getNamespace().namespace() + ".yml"){

                @Override
                public void loadDefaults() {
                    module.loadDefaults(this);
                }
            };
            module.init();
            Bukkit.getPluginManager().registerEvents((Listener)module, (Plugin)this.plugin);
        } else {
            HandlerList.unregisterAll((Listener)module);
            module.cleanup();
        }
        String name = module.getNamespace().namespace();
        this.addonFile.set(name + ".Enabled", (Object)enabled);
        module.setEnabled(enabled);
    }

    public Optional<AddonLocalData> fetchAddon(String name) {
        for (AddonLocalData localData : this.localDataMap.keySet()) {
            if (!localData.getName().equalsIgnoreCase(name)) continue;
            return Optional.of(localData);
        }
        return Optional.empty();
    }

    public Optional<AddonCloudData> fetchCloudData(String name) {
        for (AddonCloudData cloudData : this.cloudAddons) {
            if (cloudData.getName().equalsIgnoreCase(name)) {
                return Optional.of(cloudData);
            }
            if (!cloudData.getId().equalsIgnoreCase(name)) continue;
            return Optional.of(cloudData);
        }
        return Optional.empty();
    }

    public Optional<PetModule> fetchAddonModule(String name) {
        return this.fetchAddonModule(null, name);
    }

    public Optional<PetModule> fetchAddonModule(AddonLocalData localData, String name) {
        for (Map.Entry<AddonLocalData, List<PetModule>> entry : this.localDataMap.entrySet()) {
            if (localData != null && !localData.getName().equals(entry.getKey().getName())) continue;
            for (PetModule module : entry.getValue()) {
                if (!module.getNamespace().namespace().equalsIgnoreCase(name)) continue;
                return Optional.of(module);
            }
        }
        return Optional.empty();
    }

    public void update(AddonLocalData localData, String url, Runnable runnable) {
        this.localDataMap.getOrDefault(localData, Lists.newArrayList()).forEach(module -> {
            module.cleanup();
            HandlerList.unregisterAll((Listener)module);
            this.loadedAddons.remove(module);
        });
        this.localDataMap.remove(localData);
        this.downloadAddon(localData.getFile(), url, runnable);
    }

    public boolean isSupported(int build) {
        if (build <= 0) {
            return true;
        }
        String plugin = PetCore.getInstance().getDescription().getVersion().toLowerCase();
        if (!plugin.contains("-b")) {
            return false;
        }
        return Integer.parseInt(AdvString.after("-b", plugin)) >= build;
    }

    public void checkAddons() {
        HashMap addonMap = Maps.newHashMap();
        this.localDataMap.forEach((localData, modules) -> addonMap.put(localData.getName(), localData));
        this.fetchAddons(addons -> {
            ArrayList updateNeeded = Lists.newArrayList();
            addons.forEach(cloudAddon -> {
                AddonLocalData localData;
                if (addonMap.containsKey(cloudAddon.getName()) && !(localData = (AddonLocalData)addonMap.get(cloudAddon.getName())).getVersion().equals(cloudAddon.getVersion())) {
                    updateNeeded.add(cloudAddon);
                }
                this.cloudAddons.add((AddonCloudData)cloudAddon);
            });
            if (updateNeeded.isEmpty()) {
                return;
            }
            updateNeeded.forEach(addonData -> SimplePets.getDebugLogger().debug(DebugBuilder.build(this.getClass()).setLevel(DebugLevel.UPDATE).setMessages("There is an update for the addon '" + addonData.getName() + "' version " + addonData.getVersion())));
        });
    }

    public List<PetModule> getLoadedAddons() {
        return this.loadedAddons;
    }

    public void fetchAddons(Consumer<List<AddonCloudData>> consumer) {
        WebConnector.getInputStreamString("https://bsdevelopment.org/api/addons/list/SimplePets", this.plugin, result -> {
            ArrayList addons = Lists.newArrayList();
            JsonArray array = Json.parse(result).asArray();
            array.forEach(jsonValue -> {
                JsonObject json = jsonValue.asObject();
                if (json.isEmpty()) {
                    throw new AddonParsingException("Json object is not empty: '" + String.valueOf(jsonValue) + "'");
                }
                try {
                    AddonCloudData data = new AddonCloudData(json.get("id").asString(), json.get("name").asString(), json.get("description").asString(), json.get("author").asString(), json.get("version").asString(), json.get("download_url").asString(), json.get("last_updated").asString(), json.get("download_count").asInt());
                    addons.add(data);
                    this.registeredAddons.add(data.getName());
                }
                catch (Exception e) {
                    SimplePets.getDebugLogger().debug(DebugLevel.HIDDEN, "Failed to fetch data for addon: " + json.getString("name", "UNKNOWN NAME") + " (v" + json.getString("version", "UNKNOWN VERSION") + ")");
                }
            });
            consumer.accept(addons);
        });
    }

    public List<String> getRegisteredAddons() {
        return this.registeredAddons;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download(String rawURL, String backup, Consumer<File> fileConsumer) {
        try {
            URL url = new URL(rawURL);
            URLConnection connection = url.openConnection();
            connection.addRequestProperty("User-Agent", "Mozilla/5.0");
            connection.addRequestProperty("Content-Encoding", "gzip");
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            String filename = AdvString.afterLast("/", rawURL);
            File download = new File(this.folder, filename);
            ReadableByteChannel rbc = Channels.newChannel(connection.getInputStream());
            FileOutputStream fos = new FileOutputStream(download);
            try {
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            }
            finally {
                fos.close();
                fileConsumer.accept(download);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class AddonParsingException
    extends RuntimeException {
        public AddonParsingException(String message) {
            super(message);
        }
    }
}

