/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.listeners;

import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import simplepets.brainsynder.PetCore;
import simplepets.brainsynder.api.inventory.Item;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.files.MessageFile;
import simplepets.brainsynder.files.options.MessageOption;
import simplepets.brainsynder.libs.bslib.nbt.StorageTagCompound;
import simplepets.brainsynder.managers.InventoryManager;
import simplepets.brainsynder.menu.inventory.SavesMenu;
import simplepets.brainsynder.menu.inventory.holders.SavesHolder;
import simplepets.brainsynder.utils.Utilities;

public class SavesGUIListener
implements Listener {
    @EventHandler
    public void onClick(InventoryClickEvent e) {
        if (e.getInventory().getHolder() == null) {
            return;
        }
        if (!(e.getInventory().getHolder() instanceof SavesHolder)) {
            return;
        }
        final SavesMenu menu = InventoryManager.PET_SAVES;
        HumanEntity humanEntity = e.getWhoClicked();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            e.setCancelled(true);
            e.setResult(Event.Result.DENY);
            Optional<PetUser> optionalUser = SimplePets.getUserManager().getPetUser(player);
            if (!optionalUser.isPresent()) {
                return;
            }
            final PetUser user = optionalUser.get();
            if (e.getCurrentItem() == null) {
                return;
            }
            if (e.getClick().isShiftClick()) {
                e.setCancelled(true);
                return;
            }
            Optional<Item> optionalItem = SimplePets.getItemHandler().getItem(e.getCurrentItem());
            if (optionalItem.isPresent()) {
                optionalItem.get().onClick(user, menu);
                return;
            }
            if (menu.getItemStorage(user).isEmpty()) {
                return;
            }
            menu.getItemStorage(user).forEach((compound, entry) -> {
                if (Utilities.isSimilar((ItemStack)entry.getValue(), e.getCurrentItem())) {
                    if (e.getClick().isRightClick()) {
                        user.removePetSave((StorageTagCompound)compound);
                        new BukkitRunnable(this){

                            public void run() {
                                menu.open(user);
                            }
                        }.runTaskLater((Plugin)PetCore.getInstance(), 2L);
                        return;
                    }
                    if (!user.canSpawnMorePets()) {
                        e.setCancelled(true);
                        player.closeInventory();
                        player.sendMessage(MessageFile.getTranslation(MessageOption.CANT_SPAWN_MORE_PETS));
                        return;
                    }
                    if (compound.getString("PetType").equals("armor_stand")) {
                        compound.setBoolean("restricted", true);
                    }
                    Utilities.handlePetSpawning(user, (PetType)((Object)((Object)entry.getKey())), compound, true);
                }
            });
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent e) {
        if (e.getInventory().getHolder() == null) {
            return;
        }
        if (!(e.getInventory().getHolder() instanceof SavesHolder)) {
            return;
        }
        SavesMenu menu = InventoryManager.PET_SAVES;
        Bukkit.getScheduler().runTaskLater((Plugin)PetCore.getInstance(), () -> {
            if (!(e.getPlayer().getOpenInventory().getTopInventory().getHolder() instanceof SavesHolder)) {
                SimplePets.getUserManager().getPetUser((Player)e.getPlayer()).ifPresent(menu::reset);
            }
        }, 3L);
    }
}

