/*
 * Decompiled with CFR 0.152.
 */
package simplepets.brainsynder.listeners;

import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import simplepets.brainsynder.PetCore;
import simplepets.brainsynder.api.inventory.Item;
import simplepets.brainsynder.api.pet.PetType;
import simplepets.brainsynder.api.plugin.SimplePets;
import simplepets.brainsynder.api.plugin.config.ConfigOption;
import simplepets.brainsynder.api.user.PetUser;
import simplepets.brainsynder.managers.InventoryManager;
import simplepets.brainsynder.menu.inventory.PetSelectorMenu;
import simplepets.brainsynder.menu.inventory.holders.SelectorHolder;
import simplepets.brainsynder.utils.Keys;
import simplepets.brainsynder.utils.Utilities;

public class PetSelectorGUIListener
implements Listener {
    @EventHandler
    public void onClick(InventoryClickEvent e) {
        if (e.getInventory().getHolder() == null) {
            return;
        }
        if (!(e.getInventory().getHolder() instanceof SelectorHolder)) {
            return;
        }
        PetSelectorMenu menu = InventoryManager.SELECTOR;
        HumanEntity humanEntity = e.getWhoClicked();
        if (humanEntity instanceof Player) {
            Player player = (Player)humanEntity;
            e.setCancelled(true);
            e.setResult(Event.Result.DENY);
            ItemStack stack = e.getCurrentItem();
            if (stack == null) {
                return;
            }
            SimplePets.getUserManager().getPetUser(player).ifPresent(user -> {
                Optional<Item> optionalItem = SimplePets.getItemHandler().getItem(stack);
                if (optionalItem.isPresent()) {
                    if (e.getClick().isShiftClick()) {
                        optionalItem.get().onShiftClick((PetUser)user, menu);
                        return;
                    }
                    optionalItem.get().onClick((PetUser)user, menu);
                    return;
                }
                ItemMeta meta = stack.getItemMeta();
                if (!meta.getPersistentDataContainer().has(Keys.PET_TYPE_ITEM, PersistentDataType.STRING)) {
                    return;
                }
                String rawType = (String)meta.getPersistentDataContainer().get(Keys.PET_TYPE_ITEM, PersistentDataType.STRING);
                PetType.getPetType(rawType).ifPresent(type -> {
                    if (Utilities.hasPermission((CommandSender)player, type.getPermission()) || user.getOwnedPets().contains(type) && ConfigOption.INSTANCE.UTILIZE_PURCHASED_PETS.getValue().booleanValue()) {
                        menu.getTask(player.getName()).run((PetUser)user, (PetType)((Object)((Object)type)));
                    }
                });
            });
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent e) {
        if (e.getInventory().getHolder() == null) {
            return;
        }
        if (!(e.getInventory().getHolder() instanceof SelectorHolder)) {
            return;
        }
        PetSelectorMenu menu = InventoryManager.SELECTOR;
        Bukkit.getScheduler().runTaskLater((Plugin)PetCore.getInstance(), () -> {
            if (!(e.getPlayer().getOpenInventory().getTopInventory().getHolder() instanceof SelectorHolder)) {
                SimplePets.getUserManager().getPetUser((Player)e.getPlayer()).ifPresent(menu::reset);
            }
        }, 3L);
    }
}

